/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.adhoc;

import java.util.Collections;
import java.util.List;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.Affiliation;
import tigase.push.PushNotificationsComponent;
import tigase.push.adhoc.AbstractAdHocCommand;
import tigase.push.api.IPushProvider;
import tigase.push.api.IPushRepository;
import tigase.push.api.IPushSettings;
import tigase.push.modules.AffiliationChangedModule;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;

@Bean(name="unregister-device", parent=PushNotificationsComponent.class, active=true)
public class UnregisterDevice
extends AbstractAdHocCommand {
    @Inject
    private AffiliationChangedModule affiliationChangedModule;
    @Inject(nullAllowed=true)
    private List<IPushProvider> pushProviders;
    @Inject
    private IPushRepository repository;

    public String getName() {
        return "Unregister device";
    }

    public String getNode() {
        return "unregister-device";
    }

    public boolean isAllowedFor(JID jid) {
        return true;
    }

    public void setPushProviders(List<IPushProvider> pushProviders) {
        if (pushProviders == null) {
            pushProviders = Collections.emptyList();
        }
        this.pushProviders = pushProviders;
    }

    @Override
    protected Form prepareForm(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        Form form = new Form("result", "Unregister device", "Use this form to unregister device from push notifications");
        String[] stringArray = new String[this.pushProviders.size()];
        String[] stringArray2 = new String[this.pushProviders.size()];
        for (int i = 0; i < this.pushProviders.size(); ++i) {
            IPushProvider iPushProvider = this.pushProviders.get(i);
            stringArray2[i] = iPushProvider.getName();
            stringArray[i] = iPushProvider.getDescription();
        }
        form.addField(Field.fieldListSingle((String)"provider", (String)"", (String)"Provider", (String[])stringArray, (String[])stringArray2));
        form.addField(Field.fieldTextSingle((String)"device-token", (String)"", (String)"Device token"));
        return form;
    }

    @Override
    protected Form submitForm(AdhHocRequest request, AdHocResponse response, Form form) throws AdHocCommandException {
        String string = form.getAsString("provider");
        String string2 = form.getAsString("device-token");
        if (string == null || string2 == null) {
            throw new AdHocCommandException(Authorization.BAD_REQUEST, "Provider and device token must not be empty");
        }
        if (!this.pushProviders.stream().filter(iPushProvider -> iPushProvider.getName().equals(string)).findAny().isPresent()) {
            throw new AdHocCommandException(Authorization.BAD_REQUEST, "Unsupported push provider");
        }
        try {
            IPushSettings iPushSettings = this.repository.unregisterDevice(request.getRecipient().getBareJID(), request.getSender().getBareJID(), string, string2);
            if (iPushSettings.getDevices().isEmpty() || iPushSettings.getVersion() > 0) {
                this.affiliationChangedModule.notifyAffiliationChanged(iPushSettings.getServiceJid(), iPushSettings.getOwnerJid(), iPushSettings.getNode(), Affiliation.none);
            }
            Form form2 = new Form("result", "Device unregistered", "Device " + string2 + " was successfully unregistered");
            response.completeSession();
            return form2;
        }
        catch (ComponentException componentException) {
            throw new AdHocCommandException(componentException.getErrorCondition(), componentException.getMessage());
        }
        catch (RepositoryException repositoryException) {
            throw new RuntimeException(repositoryException);
        }
    }
}

