/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.adhoc;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.component.exceptions.RepositoryException;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.Affiliation;
import tigase.push.PushNotificationsComponent;
import tigase.push.adhoc.AbstractAdHocCommand;
import tigase.push.api.IPushProvider;
import tigase.push.api.IPushRepository;
import tigase.push.api.IPushSettings;
import tigase.push.modules.AffiliationChangedModule;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;

@Bean(name="register-device", parent=PushNotificationsComponent.class, active=true)
public class RegisterDevice
extends AbstractAdHocCommand {
    private static final Logger a = Logger.getLogger(RegisterDevice.class.getCanonicalName());
    @Inject
    private AffiliationChangedModule affiliationChangedModule;
    @Inject(nullAllowed=true)
    private List<IPushProvider> pushProviders;
    @Inject
    private IPushRepository repository;

    public String getName() {
        return "Register device";
    }

    public String getNode() {
        return "register-device";
    }

    public boolean isAllowedFor(JID jid) {
        return true;
    }

    public void setPushProviders(List<IPushProvider> pushProviders) {
        if (pushProviders == null) {
            pushProviders = Collections.emptyList();
        }
        this.pushProviders = pushProviders;
    }

    @Override
    protected Form prepareForm(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        Form form = new Form("result", "Register device", "Use this form to register device for push notifications");
        String[] stringArray = new String[this.pushProviders.size()];
        String[] stringArray2 = new String[this.pushProviders.size()];
        for (int i = 0; i < this.pushProviders.size(); ++i) {
            IPushProvider iPushProvider = this.pushProviders.get(i);
            stringArray2[i] = iPushProvider.getName();
            stringArray[i] = iPushProvider.getDescription();
        }
        form.addField(Field.fieldListSingle((String)"provider", (String)"", (String)"Provider", (String[])stringArray, (String[])stringArray2));
        form.addField(Field.fieldTextSingle((String)"device-token", (String)"", (String)"Device token"));
        return form;
    }

    @Override
    protected Form submitForm(AdhHocRequest request, AdHocResponse response, Form form) throws AdHocCommandException {
        String string = form.getAsString("provider");
        String string2 = form.getAsString("device-token");
        if (string == null || string2 == null) {
            throw new AdHocCommandException(Authorization.BAD_REQUEST, "Provider and device token must not be empty");
        }
        Optional<IPushProvider> optional = this.pushProviders.stream().filter(iPushProvider -> iPushProvider.getName().equals(string)).findAny();
        if (!optional.isPresent()) {
            throw new AdHocCommandException(Authorization.BAD_REQUEST, "Unsupported push provider");
        }
        String string3 = form.getAsString("device-second-token");
        try {
            Stream<IPushSettings> stream = this.repository.getNodeSettings(request.getSender().getBareJID(), string, string2);
            Optional<IPushSettings> optional2 = stream.filter(iPushSettings -> {
                if (iPushSettings.getVersion() == 0) {
                    try {
                        IPushSettings iPushSettings2 = this.repository.unregisterDevice(iPushSettings.getServiceJid(), iPushSettings.getOwnerJid(), string, string2);
                        if (iPushSettings2 != null && iPushSettings2.getDevices().isEmpty()) {
                            this.affiliationChangedModule.notifyAffiliationChanged(iPushSettings.getServiceJid(), iPushSettings.getOwnerJid(), iPushSettings.getNode(), Affiliation.none);
                        }
                    }
                    catch (Throwable throwable) {
                        a.log(Level.FINE, "Could not unregister device");
                    }
                    return false;
                }
                return !iPushSettings.getDevices().stream().noneMatch(iDevice -> Objects.equals(iDevice.getDeviceId(), string2) && Objects.equals(iDevice.getDeviceSecondId(), string3));
            }).findFirst();
            IPushSettings iPushSettings2 = optional2.orElseGet(() -> {
                try {
                    return this.repository.registerDevice(request.getRecipient().getBareJID(), request.getSender().getBareJID(), string, string2, string3);
                }
                catch (RepositoryException repositoryException) {
                    throw new RuntimeException(repositoryException);
                }
            });
            Form form2 = new Form("result", "Device registered", "Use data from form to set notifications to push service");
            form2.addField(Field.fieldTextSingle((String)"node", (String)iPushSettings2.getNode(), (String)"Node to publish notifications to"));
            optional.get().maxPayloadSize().ifPresent(n -> form2.addField(Field.fieldTextSingle((String)"max-payload-size", (String)String.valueOf(n), (String)"Maximal payload size")));
            form2.addField(Field.fieldTextMulti((String)"features", (String[])((String[])optional.get().supportedFeatures().stream().map(IPushProvider.Feature::getXMLNS).toArray(String[]::new)), (String)"Supported features"));
            response.completeSession();
            return form2;
        }
        catch (RepositoryException repositoryException) {
            throw new RuntimeException(repositoryException);
        }
    }
}

