/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.upload;

import java.time.Duration;
import tigase.component.ScheduledTask;
import tigase.http.upload.FileUploadComponent;
import tigase.http.upload.logic.Logic;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;

@Bean(name="expiration", parent=FileUploadComponent.class, active=true)
public class ExpirationTask
extends ScheduledTask {
    @ConfigField(desc="Expiration time", alias="expiration-time")
    private Duration expirationTime = Duration.ofDays(30L);
    @ConfigField(desc="Limit of slots cleared at once")
    private int limit = 10000;
    @Inject
    private Logic logic;

    public ExpirationTask() {
        super(Duration.ZERO, Duration.ofDays(1L));
    }

    public void run() {
        this.logic.removeExpired(this.expirationTime, this.limit);
    }
}

