/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.setup.questions;

import java.util.function.Consumer;
import java.util.function.Supplier;
import tigase.http.modules.setup.questions.Question;

public class SingleAnswerQuestion
extends Question {
    private final Supplier<String> getter;
    private final String label;
    private final Consumer<String> setter;

    public SingleAnswerQuestion(String id, Supplier<String> getter, Consumer<String> setter) {
        this(id, false, getter, setter);
    }

    public SingleAnswerQuestion(String id, boolean required, Supplier<String> getter, Consumer<String> setter) {
        this(id, null, required, getter, setter);
    }

    public SingleAnswerQuestion(String id, String label, Supplier<String> getter, Consumer<String> setter) {
        this(id, label, false, getter, setter);
    }

    public SingleAnswerQuestion(String id, String label, boolean required, Supplier<String> getter, Consumer<String> setter) {
        super(id);
        this.label = label;
        this.getter = getter;
        this.setter = setter;
        this.setRequired(required);
    }

    public String getLabel() {
        return this.label;
    }

    public String getValue() {
        return this.getter.get();
    }

    public void setValue(String value) {
        this.setter.accept(value);
    }

    public boolean isSelected(String value) {
        return value != null && value.equals(this.getValue());
    }

    @Override
    public boolean isValid() {
        return !this.isRequired() || this.getValue() != null && !this.getValue().isEmpty();
    }

    @Override
    public void setValues(String[] values) {
        this.setValue(values == null || values.length == 0 ? null : (values[0].trim().isEmpty() ? null : values[0]));
    }
}

