/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.setup.pages;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import tigase.http.modules.setup.Setup;
import tigase.http.modules.setup.questions.Question;

public class Page {
    private final Map<String, Question> questions = new ConcurrentHashMap<String, Question>();
    private final String title;
    private final String template;
    private Setup setup;

    public Page(String title, String template, Stream<Question> questions) {
        this.title = title;
        this.template = template;
        this.setQuestions(questions);
    }

    public Page(String title, String template, Question ... questions) {
        this(title, template, Arrays.stream(questions));
    }

    public String getId() {
        return String.valueOf(this.setup.pageId(this));
    }

    public void init(Setup setup) {
        this.setup = setup;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getTitle() {
        return this.title;
    }

    public Question getQuestion(String id) {
        return this.questions.get(id);
    }

    public void beforeDisplay() {
    }

    public String nextPage() {
        return String.valueOf(this.setup.nextPageId(this));
    }

    protected void addQuestion(Question question) {
        question.setPage(this);
        this.questions.put(question.getId(), question);
    }

    protected void setQuestions(Stream<Question> questions) {
        this.questions.clear();
        questions.forEach(this::addQuestion);
    }

    public void setValues(Map<String, String[]> params) {
        this.questions.values().forEach(question -> {
            String[] value = (String[])params.get(question.getName());
            question.setValues(value);
        });
    }

    public boolean isValid() {
        return !this.questions.values().stream().filter(question -> !question.isValid()).findFirst().isPresent();
    }
}

