/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.setup.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import tigase.http.modules.setup.Config;
import tigase.http.modules.setup.pages.Page;
import tigase.http.modules.setup.pages.SimpleConfigPage;
import tigase.http.modules.setup.questions.Question;
import tigase.http.modules.setup.questions.SingleAnswerQuestion;

public class FeaturesPage
extends Page
implements SimpleConfigPage {
    private final Config config;
    private final List<SingleAnswerQuestion> clusteringQuestions = new ArrayList<SingleAnswerQuestion>();
    private final List<SingleAnswerQuestion> featureQuestions = new ArrayList<SingleAnswerQuestion>();

    public FeaturesPage(Config config) {
        super("Features", "features.html", Stream.empty());
        this.config = config;
        this.addClusteringQuestions();
        this.addFeatureQuestions();
    }

    public List<SingleAnswerQuestion> getClusteringQuestions() {
        return this.clusteringQuestions;
    }

    public List<SingleAnswerQuestion> getFeatureQuestions() {
        return this.featureQuestions;
    }

    @Override
    public void setValues(Map<String, String[]> params) {
        super.setValues(params);
        if (this.config.getClusterMode() && (this.config.optionalComponents.contains("muc") || this.config.optionalComponents.contains("pubsub"))) {
            this.config.setACS(true);
        }
    }

    @Override
    protected void addQuestion(Question question) {
        super.addQuestion(question);
        if (question instanceof ClusteringQuestion) {
            this.clusteringQuestions.add((ClusteringQuestion)question);
        }
        if (question instanceof FeatureQuestion) {
            this.featureQuestions.add((FeatureQuestion)question);
        }
    }

    private void addClusteringQuestions() {
        ClusteringQuestion question = new ClusteringQuestion("clusterMode", "Do you want your server to run in the cluster mode?", () -> String.valueOf(this.config.getClusterMode()), val -> this.config.setClusterMode(val != null ? Boolean.parseBoolean(val) || "on".equals(val) : false));
        this.addQuestion(question);
        question = new ClusteringQuestion("acsComponent", "Tigase Advanced Clustering Strategy (ACS)", () -> String.valueOf(this.config.getACS()), val -> this.config.setACS(val != null ? Boolean.parseBoolean(val) || "on".equals(val) : false));
        this.addQuestion(question);
    }

    private void addFeatureQuestions() {
        FeatureQuestion question = new ComponentFeatureQuestion("muc", "Multi User Chat", this.config);
        this.addQuestion(question);
        question = new ComponentAndProcessorsFeatureQuestion("pubsub", "Publish-Subscribe", new String[]{"pep"}, this.config, null);
        this.addQuestion(question);
        question = new ComponentFeatureQuestion("mix", "Mediated Information eXchange", this.config);
        this.addQuestion(question);
        question = new ComponentAndProcessorsFeatureQuestion("message-archive", "Message Archive", new String[]{"urn:xmpp:mam:1", "urn:xmpp:mam:2"}, this.config, () -> {
            boolean bl = this.config.optionalComponents.remove("unified-archive");
        });
        this.addQuestion(question);
        question = new ProcessorFeatureQuestion("urn:xmpp:push:0", "PUSH Notifications", this.config);
        this.addQuestion(question);
        question = new ComponentFeatureQuestion("upload", "HTTP File Upload", this.config);
        this.addQuestion(question);
        question = new ProcessorFeatureQuestion("message-carbons", "Message Carbons", this.config);
        this.addQuestion(question);
        question = new ProcessorFeatureQuestion("urn:xmpp:csi:0", "Client State Indication", this.config);
        this.addQuestion(question);
        question = new ProcessorFeatureQuestion("motd", "Message of a Day", this.config);
        this.addQuestion(question);
        question = new ProcessorFeatureQuestion("jabber:iq:last-marker", "Last Activity", this.config);
        this.addQuestion(question);
        question = new ProcessorFeatureQuestion("spam-filter", "SPAM Filter", this.config);
        this.addQuestion(question);
    }

    private static class ClusteringQuestion
    extends SingleAnswerQuestion {
        public ClusteringQuestion(String id, String label, Supplier<String> getter, Consumer<String> setter) {
            super(id, label, getter, setter);
        }
    }

    private static class ComponentAndProcessorsFeatureQuestion
    extends FeatureQuestion {
        public ComponentAndProcessorsFeatureQuestion(String id, String label, String[] processorIds, Config config, Runnable changeListener) {
            super(id, label, () -> config.optionalComponents.contains(id) && config.plugins.containsAll(Arrays.asList(processorIds)) ? id : null, (String val) -> {
                if (val != null && (Boolean.parseBoolean(val) || "on".equals(val))) {
                    config.optionalComponents.add(id);
                    config.plugins.addAll(Arrays.asList(processorIds));
                } else {
                    config.optionalComponents.remove(id);
                    config.plugins.removeAll(Arrays.asList(processorIds));
                }
                if (changeListener != null) {
                    changeListener.run();
                }
            });
        }
    }

    private static class ComponentFeatureQuestion
    extends FeatureQuestion {
        public ComponentFeatureQuestion(String id, String label, Config config) {
            super(id, label, () -> config.optionalComponents.contains(id) ? id : null, (String val) -> {
                if (val != null && (Boolean.parseBoolean(val) || "on".equals(val))) {
                    config.optionalComponents.add(id);
                } else {
                    config.optionalComponents.remove(id);
                }
            });
        }
    }

    private static class FeatureQuestion
    extends SingleAnswerQuestion {
        public FeatureQuestion(String id, String label, Supplier<String> getter, Consumer<String> setter) {
            super(id, label, getter, setter);
        }
    }

    private static class ProcessorFeatureQuestion
    extends FeatureQuestion {
        public ProcessorFeatureQuestion(String id, String label, Config config) {
            super(id, label, () -> config.plugins.contains(id) ? id : null, (String val) -> {
                if (val != null && (Boolean.parseBoolean(val) || "on".equals(val))) {
                    config.plugins.add(id);
                } else {
                    config.plugins.remove(id);
                }
            });
        }
    }
}

