/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.setup;

import java.util.logging.Logger;
import tigase.auth.credentials.Credentials;
import tigase.db.AuthRepository;
import tigase.db.AuthorizationException;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.http.DeploymentInfo;
import tigase.http.HttpMessageReceiver;
import tigase.http.ServiceImpl;
import tigase.http.ServletInfo;
import tigase.http.api.Service;
import tigase.http.modules.AbstractBareModule;
import tigase.http.modules.Module;
import tigase.http.modules.setup.AGPLLicenseServlet;
import tigase.http.modules.setup.SetupServlet;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;

@Bean(name="setup", parent=HttpMessageReceiver.class, active=true)
public class SetupModule
extends AbstractBareModule
implements Module {
    private static final Logger log = Logger.getLogger(SetupModule.class.getCanonicalName());
    @ConfigField(desc="Allow access to setup with password", alias="admin-password")
    private String adminPassword = null;
    @ConfigField(desc="Allow access to setup for user", alias="admin-user")
    private String adminUser = null;
    @Inject(nullAllowed=true)
    private AuthRepository authRepo;
    private DeploymentInfo httpDeployment = null;
    private Service service = null;

    @Override
    public String getDescription() {
        return "Setup - handles basic configuration of Tigase XMPP Server";
    }

    @Override
    public boolean isRequestAllowed(String key, String domain, String path) {
        return false;
    }

    @Override
    public void start() {
        if (this.httpDeployment != null) {
            this.stop();
        }
        this.service = new ServiceImpl(this){

            @Override
            public boolean isAdmin(BareJID user) {
                return user.toString().equals(SetupModule.this.adminUser) || super.isAdmin(user);
            }

            @Override
            public boolean checkCredentials(String user, String password) throws TigaseStringprepException, TigaseDBException, AuthorizationException {
                if (SetupModule.this.adminUser != null && SetupModule.this.adminPassword != null && SetupModule.this.adminUser.equals(user) && SetupModule.this.adminPassword.equals(password)) {
                    return true;
                }
                AuthRepository authRepository = SetupModule.this.getAuthRepository();
                if (authRepository == null) {
                    return false;
                }
                BareJID jid = BareJID.bareJIDInstance((String)user);
                Credentials credentials = authRepository.getCredentials(jid, "default");
                if (credentials == null) {
                    return false;
                }
                return credentials.getFirst().verifyPlainPassword(password);
            }
        };
        super.start();
        this.httpDeployment = this.httpServer.deployment().setClassLoader(this.getClass().getClassLoader()).setContextPath(this.contextPath).setService(this.service).setDeploymentName("Setup").setDeploymentDescription(this.getDescription());
        if (this.vhosts != null) {
            this.httpDeployment.setVHosts(this.vhosts);
        }
        ServletInfo servletInfo = this.httpServer.servlet("SetupServlet", SetupServlet.class).addInitParam("module", this.uuid);
        servletInfo.addMapping("/*");
        this.httpDeployment.addServlets(servletInfo);
        servletInfo = this.httpServer.servlet("AGPLLicenseServlet", AGPLLicenseServlet.class);
        servletInfo.addMapping("/license/agpl.html");
        this.httpDeployment.addServlets(servletInfo);
        this.httpServer.deploy(this.httpDeployment);
    }

    @Override
    public void stop() {
        if (this.httpDeployment != null) {
            this.httpServer.undeploy(this.httpDeployment);
            this.httpDeployment = null;
        }
        super.stop();
    }

    @Override
    public UserRepository getUserRepository() {
        return null;
    }

    @Override
    public AuthRepository getAuthRepository() {
        return this.authRepo;
    }

    protected Service getService() {
        return this.service;
    }
}

