/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.rest;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import tigase.http.DeploymentInfo;
import tigase.http.HttpMessageReceiver;
import tigase.http.PacketWriter;
import tigase.http.ServiceImpl;
import tigase.http.ServletInfo;
import tigase.http.modules.AbstractModule;
import tigase.http.modules.rest.ApiKeyAddCmd;
import tigase.http.modules.rest.ApiKeyRemoveCmd;
import tigase.http.modules.rest.ApiKeyRepository;
import tigase.http.modules.rest.ApiKeyUpdateCmd;
import tigase.http.modules.rest.ReloadHandlersCmd;
import tigase.http.modules.rest.RestExtServlet;
import tigase.http.modules.rest.RestServlet;
import tigase.http.modules.rest.RestServletIfc;
import tigase.http.stats.HttpStatsCollector;
import tigase.http.util.StaticFileServlet;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.core.BeanConfig;
import tigase.kernel.core.Kernel;
import tigase.server.script.CommandIfc;
import tigase.stats.StatisticHolder;
import tigase.stats.StatisticHolderImpl;
import tigase.stats.StatisticsList;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="rest", parent=HttpMessageReceiver.class, active=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode, ConfigTypeEnum.SessionManagerMode, ConfigTypeEnum.ConnectionManagersMode, ConfigTypeEnum.ComponentMode})
public class RestModule
extends AbstractModule {
    private static final Logger log = Logger.getLogger(RestModule.class.getCanonicalName());
    private static final String DEF_SCRIPTS_DIR_VAL = "scripts/rest";
    private static final String SCRIPTS_DIR_KEY = "rest-scripts-dir";
    private static final ConcurrentHashMap<String, StatisticHolder> stats = new ConcurrentHashMap();
    private final CommandIfc[] commands = new CommandIfc[]{new ReloadHandlersCmd(this), new ApiKeyAddCmd(this), new ApiKeyRemoveCmd(this), new ApiKeyUpdateCmd(this)};
    private DeploymentInfo httpDeployment = null;
    private List<RestServletIfc> restServlets = new ArrayList<RestServletIfc>();
    @ConfigField(desc="Scripts directory", alias="rest-scripts-dir")
    private String scriptsDir = "scripts/rest";
    @Inject
    private ApiKeyRepository apiKeyRepository;
    @Inject(nullAllowed=true)
    private List<HttpStatsCollector> statsCollectors = Collections.emptyList();

    public static File[] getGroovyFiles(File scriptsDirFile) {
        if (scriptsDirFile.exists()) {
            return scriptsDirFile.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String s) {
                    return s.endsWith("groovy");
                }
            });
        }
        if (log.isLoggable(Level.WARNING)) {
            log.log(Level.WARNING, "scripts directory {0} does not exist!", scriptsDirFile);
        }
        return new File[0];
    }

    @Override
    public void everyHour() {
        for (StatisticHolder holder : stats.values()) {
            holder.everyHour();
        }
    }

    @Override
    public void everyMinute() {
        for (StatisticHolder holder : stats.values()) {
            holder.everyMinute();
        }
    }

    @Override
    public void everySecond() {
        for (StatisticHolder holder : stats.values()) {
            holder.everySecond();
        }
    }

    @Override
    public String getDescription() {
        return "REST support - handles HTTP REST access using scripts";
    }

    public void setApiKeyRepository(ApiKeyRepository apiKeyRepository) {
        if (this.getComponentName() != null) {
            apiKeyRepository.setRepoUser(BareJID.bareJIDInstanceNS((String)this.getName(), (String)this.getComponentName()));
            apiKeyRepository.setRepo(this.getUserRepository());
        }
        this.apiKeyRepository = apiKeyRepository;
    }

    @Override
    public boolean isRequestAllowed(String key, String domain, String path) {
        return this.apiKeyRepository.isAllowed(key, domain, path);
    }

    @Override
    public void start() {
        ServletInfo servletInfo;
        File scriptsDirFile;
        File[] scriptDirFiles;
        if (this.httpDeployment != null) {
            this.stop();
        }
        super.start();
        this.httpDeployment = this.httpServer.deployment().setClassLoader(this.getClass().getClassLoader()).setContextPath(this.contextPath).setService(new ServiceImpl<RestModule>(this)).setDeploymentName("REST API").setDeploymentDescription(this.getDescription());
        if (this.vhosts != null) {
            this.httpDeployment.setVHosts(this.vhosts);
        }
        if ((scriptDirFiles = (scriptsDirFile = new File(this.scriptsDir)).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && !"static".equals(file.getName());
            }
        })) != null) {
            File[] fileArray = scriptDirFiles;
            int n = scriptDirFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File dirFile = fileArray[n2];
                try {
                    this.startRestServletForDirectory(this.httpDeployment, dirFile);
                }
                catch (IOException ex) {
                    log.log(Level.FINE, "Exception while scanning for scripts to load", ex);
                }
                ++n2;
            }
        }
        try {
            servletInfo = this.httpServer.servlet("RestServlet", RestExtServlet.class);
            servletInfo.addInitParam(RestServlet.REST_MODULE_KEY, this.uuid).addInitParam(RestServlet.SCRIPTS_DIR_KEY, scriptsDirFile.getCanonicalPath()).addMapping("/");
            this.httpDeployment.addServlets(servletInfo);
        }
        catch (IOException ex) {
            log.log(Level.FINE, "Exception while scanning for scripts to load", ex);
        }
        servletInfo = this.httpServer.servlet("StaticServlet", StaticFileServlet.class);
        servletInfo.addInitParam("directory", new File(scriptsDirFile, "static").getAbsolutePath()).addMapping("/static/*");
        this.httpDeployment.addServlets(servletInfo);
        this.httpServer.deploy(this.httpDeployment);
    }

    @Override
    public void stop() {
        if (this.httpDeployment != null) {
            this.httpServer.undeploy(this.httpDeployment);
            this.httpDeployment = null;
        }
        Kernel kernel = RestModule.getKernel(this.uuid);
        for (BeanConfig bc : kernel.getDependencyManager().getBeanConfigs()) {
            if (Kernel.class.isAssignableFrom(bc.getClazz()) || ApiKeyRepository.class.isAssignableFrom(bc.getClazz()) || RestModule.class.isAssignableFrom(bc.getClazz()) || bc.getState() != BeanConfig.State.initialized) continue;
            try {
                kernel.unregister(bc.getBeanName());
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Could not unregister bean!", ex);
            }
        }
        this.restServlets = new ArrayList<RestServletIfc>();
        super.stop();
        this.apiKeyRepository.setAutoloadTimer(0L);
    }

    @Override
    public void getStatistics(String compName, StatisticsList list) {
        for (StatisticHolder holder : stats.values()) {
            holder.getStatistics(compName, list);
        }
    }

    public void countRequest(HttpServletRequest request) {
        this.statsCollectors.forEach(collector -> collector.count(request));
    }

    @Override
    public void executedIn(String path, long executionTime) {
        StatisticHolder holder = stats.get(path);
        if (holder == null) {
            StatisticHolderImpl tmp = new StatisticHolderImpl();
            tmp.setStatisticsPrefix(String.valueOf(this.getName()) + ", path=" + path);
            holder = stats.putIfAbsent(path, (StatisticHolder)tmp);
            if (holder == null) {
                holder = tmp;
            }
        }
        holder.statisticExecutedIn(executionTime);
    }

    @Override
    public void statisticExecutedIn(long executionTime) {
    }

    public Kernel getKernel() {
        return RestModule.getKernel(this.uuid);
    }

    @Override
    public void init(JID jid, String componentName, PacketWriter writer) {
        super.init(jid, componentName, writer);
        this.setApiKeyRepository(this.apiKeyRepository);
    }

    @Override
    public void initialize() {
        super.initialize();
        Arrays.stream(this.commands).forEach(this.commandManager::registerCmd);
    }

    @Override
    public void beforeUnregister() {
        super.beforeUnregister();
        Arrays.stream(this.commands).forEach(this.commandManager::unregisterCmd);
    }

    protected void registerRestServlet(RestServletIfc servlet) {
        this.restServlets.add(servlet);
    }

    protected ApiKeyRepository getApiKeyRepository() {
        return this.apiKeyRepository;
    }

    protected List<? extends RestServletIfc> getRestServlets() {
        return this.restServlets;
    }

    private void startRestServletForDirectory(DeploymentInfo httpDeployment, File scriptsDirFile) throws IOException {
        File[] scriptFiles = RestModule.getGroovyFiles(scriptsDirFile);
        if (scriptFiles != null) {
            ServletInfo servletInfo = this.httpServer.servlet("RestServlet", RestExtServlet.class);
            servletInfo.addInitParam(RestServlet.REST_MODULE_KEY, this.uuid).addInitParam(RestServlet.SCRIPTS_DIR_KEY, scriptsDirFile.getCanonicalPath()).addInitParam("mapping", "/" + scriptsDirFile.getName() + "/*").addMapping("/" + scriptsDirFile.getName() + "/*");
            httpDeployment.addServlets(servletInfo);
        }
    }
}

