/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.rest;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import tigase.db.DBInitException;
import tigase.db.UserRepository;
import tigase.db.comp.RepositoryItem;
import tigase.db.comp.UserRepoRepository;
import tigase.eventbus.EventBus;
import tigase.eventbus.HandleEvent;
import tigase.http.modules.AbstractModule;
import tigase.http.modules.rest.ApiKeyItem;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.xmpp.jid.BareJID;

@Bean(name="repository", parent=AbstractModule.class, active=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode, ConfigTypeEnum.SessionManagerMode, ConfigTypeEnum.ConnectionManagersMode, ConfigTypeEnum.ComponentMode})
public class ApiKeyRepository
extends UserRepoRepository<ApiKeyItem> {
    public static final String API_KEYS_KEY = "api-keys";
    private static final String GEN_API_KEYS = "--api-keys";
    @ConfigField(desc="Configure REST API to be open and avoid requirement for api-key", alias="open-access")
    private boolean openAccess = false;
    private BareJID repoUserJid;
    @Inject
    private EventBus eventBus;

    public BareJID getRepoUser() {
        return this.repoUserJid;
    }

    public void setRepoUser(BareJID repoUserJid) {
        this.repoUserJid = repoUserJid;
    }

    public String getConfigKey() {
        return API_KEYS_KEY;
    }

    public String[] getDefaultPropetyItems() {
        return new String[0];
    }

    public String getItemsListPKey() {
        return API_KEYS_KEY;
    }

    public String getPropertyKey() {
        return GEN_API_KEYS;
    }

    public ApiKeyItem getItemInstance() {
        return new ApiKeyItem();
    }

    public boolean isAllowed(String key, String domain, String path) {
        ApiKeyItem item;
        if (this.openAccess) {
            return true;
        }
        if (key == null) {
            key = "open_access";
        }
        if ((item = (ApiKeyItem)this.getItem(key)) == null) {
            return false;
        }
        return item.isAllowed(key, domain, path);
    }

    public void setRepo(UserRepository userRepository) {
        if (this.getRepoUser() != null) {
            super.setRepo(userRepository);
        }
    }

    public void destroy() {
    }

    @Deprecated
    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
    }

    public void initialize() {
        super.initialize();
        this.eventBus.registerAll((Object)this);
    }

    public void beforeUnregister() {
        this.eventBus.unregisterAll((Object)this);
        super.beforeUnregister();
    }

    public void addItem(ApiKeyItem item) {
        super.addItem((RepositoryItem)item);
        this.eventBus.fire((Object)new ItemsChangedEvent(this.repoUserJid.getLocalpart()));
    }

    public void removeItem(String key) {
        super.removeItem(key);
        this.eventBus.fire((Object)new ItemsChangedEvent(this.repoUserJid.getLocalpart()));
    }

    @HandleEvent
    public void itemsChanged(ItemsChangedEvent itemsChanged) {
        if (!itemsChanged.checkModule(this.repoUserJid.getLocalpart())) {
            return;
        }
        super.reload();
    }

    public static class ItemsChangedEvent
    implements Serializable {
        private String module;
        private transient boolean local = false;

        public ItemsChangedEvent() {
        }

        public ItemsChangedEvent(String module) {
            this.module = module;
        }

        public boolean checkModule(String module) {
            return Objects.equals(this.module, module);
        }

        public boolean isLocal() {
            return this.local;
        }
    }
}

