/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.stringprep;

import java.util.concurrent.TimeUnit;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.util.stringprep.XMPPStringPrepEmpty;
import tigase.util.stringprep.XMPPStringPrepIfc;
import tigase.util.stringprep.XMPPStringPrepLibIDN;
import tigase.util.stringprep.XMPPStringPrepSimple;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public abstract class XMPPStringPrepFactory {
    public static final String STRINGPREP_PROCESSOR_PROP_KEY = "stringprep-processor";
    public static final String[] STRINGPREP_PROCESSORS = new String[]{"libidn", "simple", "empty"};
    public static String STRINGPREP_PROCESSOR = "simple";

    private static boolean doWithJID(JID jid) {
        return jid.toString() != null;
    }

    public static XMPPStringPrepIfc getDefaultXMPPStringPrep() {
        STRINGPREP_PROCESSOR = System.getProperty(STRINGPREP_PROCESSOR_PROP_KEY, STRINGPREP_PROCESSOR);
        return XMPPStringPrepFactory.getXMPPStringPrep(STRINGPREP_PROCESSOR);
    }

    public static XMPPStringPrepIfc getEmptyXMPPStringPrep() {
        return new XMPPStringPrepEmpty();
    }

    public static XMPPStringPrepIfc getLibIDNXMPPStringPrep() {
        return new XMPPStringPrepLibIDN();
    }

    public static XMPPStringPrepIfc getSimpleXMPPStringPrep() {
        return new XMPPStringPrepSimple();
    }

    public static XMPPStringPrepIfc getXMPPStringPrep(String stringprepProcessor) {
        if ("simple".equals(stringprepProcessor)) {
            return XMPPStringPrepFactory.getSimpleXMPPStringPrep();
        }
        if ("libidn".equals(stringprepProcessor)) {
            return XMPPStringPrepFactory.getLibIDNXMPPStringPrep();
        }
        if ("empty".equals(stringprepProcessor)) {
            return XMPPStringPrepFactory.getEmptyXMPPStringPrep();
        }
        try {
            return (XMPPStringPrepIfc)Class.forName(stringprepProcessor).newInstance();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Incorrect stringprep class name: " + stringprepProcessor, ex);
        }
    }

    public static void main(String[] args) throws Exception {
        long testTime = 30L;
        System.out.printf("Each test time: %1$,d seconds\n", testTime);
        for (String proc : STRINGPREP_PROCESSORS) {
            long result = XMPPStringPrepFactory.runTest(TimeUnit.SECONDS.toMillis(testTime), proc);
            System.out.printf("Stringprep processor: %1$s, result: %2$,d\n", proc, result);
        }
    }

    private static long runTest(long time, String stringprep) throws TigaseStringprepException {
        BareJID.useStringprepProcessor(stringprep);
        long testEnd = System.currentTimeMillis() + time;
        long loopCount = 0L;
        StringBuilder sb = new StringBuilder(4096);
        boolean boolResult = true;
        while (System.currentTimeMillis() < testEnd) {
            sb.delete(0, sb.length());
            sb.append("User_Local_Part_").append(++loopCount).append("@JID_Domain_Part_");
            sb.append(loopCount).append("/Resource Part ").append(loopCount);
            boolResult &= XMPPStringPrepFactory.doWithJID(JID.jidInstance(sb.toString()));
        }
        System.out.println("Test completed: " + boolResult);
        return loopCount;
    }
}

