/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Algorithms {
    private static final String HASH_ALGO = "SHA-256";
    private static final String HMAC_ALGO = "HmacSHA256";
    private static final byte[] NULL_CHARS_ARRAY = new byte[]{110, 117, 108, 108};

    public static void $main(String[] args) throws Exception {
        String id = null;
        String pass = null;
        String alg = "MD5";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-h")) {
                System.out.println(Algorithms.help());
                System.exit(0);
            }
            if (args[i].equals("-id")) {
                id = args[++i];
            }
            if (args[i].equals("-pass")) {
                pass = args[++i];
            }
            if (!args[i].equals("-alg")) continue;
            alg = args[++i];
        }
        if (id == null) {
            id = "";
        }
        System.out.println(Algorithms.hexDigest(id, pass, alg));
    }

    public static final String bytesToHex(byte[] buff) {
        StringBuilder res = new StringBuilder();
        for (byte b : buff) {
            char ch = Character.forDigit(b >> 4 & 0xF, 16);
            res.append(ch);
            ch = Character.forDigit(b & 0xF, 16);
            res.append(ch);
        }
        return res.toString();
    }

    public static final byte[] digest(String id, String secret, String alg) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(alg);
        if (id == null) {
            md.update(NULL_CHARS_ARRAY);
        } else {
            md.update(id.getBytes());
        }
        if (secret == null) {
            md.update(NULL_CHARS_ARRAY);
        } else {
            md.update(secret.getBytes());
        }
        return md.digest();
    }

    public static String generateDialbackKey(String originatingServer, String receivingServer, String secret, String streamID) {
        try {
            Charset charSet = Charset.forName("US-ASCII");
            Mac sha = Mac.getInstance(HMAC_ALGO);
            SecretKeySpec secret_key = new SecretKeySpec(charSet.encode(Algorithms.sha256(secret)).array(), HMAC_ALGO);
            sha.init(secret_key);
            sha.update(receivingServer.getBytes());
            sha.update((byte)32);
            sha.update(originatingServer.getBytes());
            sha.update((byte)32);
            sha.update(streamID.getBytes());
            return Algorithms.bytesToHex(sha.doFinal());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String help() {
        return " -id id\t\t\t\tid used to calculate digest\n -pass pass\t\t\tpassword phrase for digest calculation\n -alg alg\t\t\talgorith to use for calculating digest\n";
    }

    public static final String hexDigest(String id, String secret, String alg) throws NoSuchAlgorithmException {
        return Algorithms.bytesToHex(Algorithms.digest(id, secret, alg));
    }

    public static String sha256(String data) {
        try {
            MessageDigest sha = MessageDigest.getInstance(HASH_ALGO);
            return Algorithms.bytesToHex(sha.digest(data.getBytes()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Algorithms() {
    }
}

