/*
 * Decompiled with CFR 0.152.
 */
package tigase.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import tigase.form.Field;
import tigase.form.Fields;
import tigase.form.Form;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

public class MultiItemForm
extends Form {
    private final List<Fields> items = new ArrayList<Fields>();
    private Fields reported = null;

    public static void main(String[] args) {
        MultiItemForm multiItemForm = new MultiItemForm("tytul");
        multiItemForm.setInstruction("bla");
        Fields f = new Fields();
        f.addField(Field.fieldTextSingle("var1", "val11", null));
        f.addField(Field.fieldTextSingle("var2", "val12", null));
        f.addField(Field.fieldTextSingle("var3", "val13", null));
        multiItemForm.addItem(f);
        f = new Fields();
        f.addField(Field.fieldTextSingle("var1", "val21", null));
        f.addField(Field.fieldTextSingle("var5", "val22", null));
        multiItemForm.addItem(f);
        f = new Fields();
        f.addField(Field.fieldTextSingle("var4", "val31", null));
        f.addField(Field.fieldTextSingle("var5", "val32", null));
        multiItemForm.addItem(f);
        System.out.println(multiItemForm.getElement().toStringPretty());
        multiItemForm = new MultiItemForm("tytul");
        System.out.println(multiItemForm.getElement());
    }

    public MultiItemForm() {
        super("result", null, null);
    }

    public MultiItemForm(String title) {
        super("result", title, null);
    }

    public MultiItemForm(Element form) {
        super(form);
    }

    public MultiItemForm(Form form) {
        super("result", null, null);
        this.setReported(form.getAllFields());
    }

    @Override
    public Element getElement() {
        if (this.reported == null || this.items == null) {
            return null;
        }
        Element form = super.getElement();
        Element report = new Element("reported");
        for (Field field : this.reported.getAllFields()) {
            report.addChild((XMLNodeIfc)field.getElement());
        }
        form.addChild((XMLNodeIfc)report);
        for (Fields fieldsItems : this.items) {
            Element item = new Element("item");
            for (Field field : fieldsItems.getAllFields()) {
                item.addChild((XMLNodeIfc)field.getElement(false, false));
            }
            if (item.getChildren() == null || item.getChildren().isEmpty()) continue;
            form.addChild((XMLNodeIfc)item);
        }
        return form;
    }

    public void addItem(Fields i) {
        if (this.reported == null) {
            this.reported = new Fields();
            for (Field field : i.getAllFields()) {
                this.reported.addField(field.cloneShalow());
            }
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.log(Level.WARNING, "Initialised MultiItemForm with first item vars: {0}", this.reported.getAllFields());
            }
        }
        Iterator<Field> iterator = i.getAllFields().iterator();
        while (iterator.hasNext()) {
            Field field;
            field = iterator.next();
            if (this.reported.is(field.getVar())) continue;
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "variable {0} of added {1} does not match reported fields: {2} - removing!", new Object[]{field.getVar(), i.getAllFields(), this.reported.getAllFields()});
            }
            iterator.remove();
        }
        Collections.sort(i.getAllFields());
        if (i.getAllFields().size() > 0) {
            for (Field repField : this.reported.getAllFields()) {
                if (i.get(repField.getVar()) != null) continue;
                i.addField(Field.fieldTextSingle(repField.getVar(), null, null));
            }
        }
        this.items.add(i);
    }

    public List<Fields> getAllItems() {
        return this.items;
    }

    public void setReported(List<Field> fields) {
        if (this.reported == null) {
            this.reported = new Fields();
        }
        for (Field field : fields) {
            if (field.getType().equals((Object)Field.FieldType.hidden) || field.getType().equals((Object)Field.FieldType.fixed)) continue;
            this.reported.addField(field.cloneShalow());
        }
    }
}

