/*
 * Decompiled with CFR 0.152.
 */
package ca.pjer.logback;

import ca.pjer.logback.Lazy;
import ca.pjer.logback.metrics.AwsLogsMetricsHolder;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.logs.AWSLogs;
import com.amazonaws.services.logs.AWSLogsClientBuilder;
import com.amazonaws.services.logs.model.CreateLogGroupRequest;
import com.amazonaws.services.logs.model.CreateLogStreamRequest;
import com.amazonaws.services.logs.model.DataAlreadyAcceptedException;
import com.amazonaws.services.logs.model.InputLogEvent;
import com.amazonaws.services.logs.model.InvalidSequenceTokenException;
import com.amazonaws.services.logs.model.PutLogEventsRequest;
import com.amazonaws.services.logs.model.PutLogEventsResult;
import com.amazonaws.services.logs.model.PutRetentionPolicyRequest;
import com.amazonaws.services.logs.model.ResourceAlreadyExistsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;

class AWSLogsStub {
    private final Comparator<InputLogEvent> inputLogEventByTimestampComparator = Comparator.comparing(InputLogEvent::getTimestamp);
    private final String logGroupName;
    private final String logStreamName;
    private final String logRegion;
    private final String cloudWatchEndpoint;
    private final boolean verbose;
    private String sequenceToken;
    private Long lastTimestamp;
    private int retentionTimeInDays;
    private final Lazy<AWSLogs> lazyAwsLogs = new Lazy();

    AWSLogsStub(String logGroupName, String logStreamName, String logRegion, int retentionTimeInDays, String cloudWatchEndpoint, boolean verbose) {
        this.logGroupName = logGroupName;
        this.logStreamName = logStreamName;
        this.logRegion = logRegion;
        this.retentionTimeInDays = retentionTimeInDays;
        this.cloudWatchEndpoint = cloudWatchEndpoint;
        this.verbose = verbose;
    }

    private AWSLogs awsLogs() {
        return this.lazyAwsLogs.getOrCompute(() -> {
            if (this.verbose) {
                System.out.println("Creating AWSLogs Client");
            }
            AWSLogsClientBuilder builder = AWSLogsClientBuilder.standard();
            if (Objects.nonNull(this.cloudWatchEndpoint)) {
                AwsClientBuilder.EndpointConfiguration endpointConfiguration = new AwsClientBuilder.EndpointConfiguration(this.cloudWatchEndpoint, this.logRegion);
                builder.setEndpointConfiguration(endpointConfiguration);
            } else {
                Optional.ofNullable(this.logRegion).ifPresent(arg_0 -> ((AWSLogsClientBuilder)builder).setRegion(arg_0));
            }
            AWSLogs awsLogs = (AWSLogs)builder.build();
            this.initLogGroup(awsLogs);
            return awsLogs;
        });
    }

    private void initLogGroup(AWSLogs awsLogs) {
        block8: {
            block7: {
                try {
                    awsLogs.createLogGroup(new CreateLogGroupRequest().withLogGroupName(this.logGroupName));
                    if (this.retentionTimeInDays > 0) {
                        awsLogs.putRetentionPolicy(new PutRetentionPolicyRequest().withLogGroupName(this.logGroupName).withRetentionInDays(Integer.valueOf(this.retentionTimeInDays)));
                    }
                }
                catch (ResourceAlreadyExistsException resourceAlreadyExistsException) {
                }
                catch (Throwable t) {
                    if (!this.verbose) break block7;
                    t.printStackTrace();
                }
            }
            try {
                awsLogs.createLogStream(new CreateLogStreamRequest().withLogGroupName(this.logGroupName).withLogStreamName(this.logStreamName));
            }
            catch (ResourceAlreadyExistsException t) {
            }
            catch (Throwable t) {
                if (!this.verbose) break block8;
                t.printStackTrace();
            }
        }
    }

    synchronized void start() {
    }

    synchronized void stop() {
        try {
            this.awsLogs().shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void logEvents(Collection<InputLogEvent> events) {
        if (events.size() > 1) {
            ArrayList<InputLogEvent> sortedEvents = new ArrayList<InputLogEvent>(events);
            Collections.sort(sortedEvents, this.inputLogEventByTimestampComparator);
            events = sortedEvents;
        }
        for (InputLogEvent event : events) {
            if (this.lastTimestamp != null && event.getTimestamp() < this.lastTimestamp) {
                event.setTimestamp(this.lastTimestamp);
                continue;
            }
            this.lastTimestamp = event.getTimestamp();
        }
        AwsLogsMetricsHolder.get().incrementLogEvents(events.size());
        AwsLogsMetricsHolder.get().incrementPutLog();
        this.logPreparedEvents(events);
    }

    private void logPreparedEvents(Collection<InputLogEvent> events) {
        try {
            PutLogEventsRequest request = new PutLogEventsRequest().withLogGroupName(this.logGroupName).withLogStreamName(this.logStreamName).withSequenceToken(this.sequenceToken).withLogEvents(events);
            PutLogEventsResult result = this.awsLogs().putLogEvents(request);
            this.sequenceToken = result.getNextSequenceToken();
        }
        catch (DataAlreadyAcceptedException e) {
            this.sequenceToken = e.getExpectedSequenceToken();
        }
        catch (InvalidSequenceTokenException e) {
            this.sequenceToken = e.getExpectedSequenceToken();
            this.logPreparedEvents(events);
        }
        catch (Throwable t) {
            if (this.verbose) {
                t.printStackTrace();
            }
            AwsLogsMetricsHolder.get().incrementPutLogFailed(t);
            throw t;
        }
    }
}

