/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsKeyExchange;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.TlsCredentialedAgreement;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsECCUtils;
import org.bouncycastle.tls.TlsECConfigVerifier;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsSecret;

public class TlsECDHKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsECConfigVerifier ecConfigVerifier;
    protected short[] clientECPointFormats;
    protected short[] serverECPointFormats;
    protected TlsCredentialedAgreement agreementCredentials;
    protected TlsCertificate ecdhPeerCertificate;
    protected TlsECConfig ecConfig;
    protected TlsAgreement agreement;

    private static int checkKeyExchange(int n) {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return n;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsECDHKeyExchange(int n, Vector vector, TlsECConfigVerifier tlsECConfigVerifier, short[] sArray, short[] sArray2) {
        this(n, vector, tlsECConfigVerifier, null, sArray, sArray2);
    }

    public TlsECDHKeyExchange(int n, Vector vector, TlsECConfig tlsECConfig, short[] sArray) {
        this(n, vector, null, tlsECConfig, null, sArray);
    }

    private TlsECDHKeyExchange(int n, Vector vector, TlsECConfigVerifier tlsECConfigVerifier, TlsECConfig tlsECConfig, short[] sArray, short[] sArray2) {
        super(TlsECDHKeyExchange.checkKeyExchange(n), vector);
        this.ecConfigVerifier = tlsECConfigVerifier;
        this.ecConfig = tlsECConfig;
        this.clientECPointFormats = sArray;
        this.serverECPointFormats = sArray2;
    }

    public void skipServerCredentials() throws IOException {
        if (this.keyExchange != 20) {
            throw new TlsFatalAlert(80);
        }
    }

    public void processServerCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (this.keyExchange == 20) {
            throw new TlsFatalAlert(80);
        }
        if (!(tlsCredentials instanceof TlsCredentialedAgreement)) {
            throw new TlsFatalAlert(80);
        }
        this.agreementCredentials = (TlsCredentialedAgreement)tlsCredentials;
    }

    public void processServerCertificate(Certificate certificate) throws IOException {
        if (this.keyExchange == 20) {
            throw new TlsFatalAlert(10);
        }
        this.checkServerCertSigAlg(certificate);
        this.ecdhPeerCertificate = this.validatePeerCertificate(0, certificate);
    }

    public boolean requiresServerKeyExchange() {
        switch (this.keyExchange) {
            case 17: 
            case 19: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    public byte[] generateServerKeyExchange() throws IOException {
        if (!this.requiresServerKeyExchange()) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsECCUtils.writeECConfig(this.ecConfig, byteArrayOutputStream);
        this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
        this.generateEphemeral(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        if (!this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(10);
        }
        this.ecConfig = TlsECCUtils.receiveECConfig(this.ecConfigVerifier, this.serverECPointFormats, inputStream);
        byte[] byArray = TlsUtils.readOpaque8(inputStream);
        this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
        this.processEphemeral(this.clientECPointFormats, byArray);
    }

    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        if (this.keyExchange == 20) {
            throw new TlsFatalAlert(40);
        }
        short[] sArray = certificateRequest.getCertificateTypes();
        block3: for (int i = 0; i < sArray.length; ++i) {
            switch (sArray[i]) {
                case 65: 
                case 66: {
                    continue block3;
                }
                default: {
                    throw new TlsFatalAlert(47);
                }
            }
        }
    }

    public void processClientCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (this.keyExchange == 20) {
            throw new TlsFatalAlert(80);
        }
        if (!(tlsCredentials instanceof TlsCredentialedAgreement)) {
            throw new TlsFatalAlert(80);
        }
        this.agreementCredentials = (TlsCredentialedAgreement)tlsCredentials;
    }

    public void generateClientKeyExchange(OutputStream outputStream) throws IOException {
        if (this.agreementCredentials == null) {
            this.generateEphemeral(outputStream);
        }
    }

    public void processClientCertificate(Certificate certificate) throws IOException {
        if (this.keyExchange == 20) {
            throw new TlsFatalAlert(10);
        }
        if (this.agreementCredentials != null) {
            this.ecdhPeerCertificate = this.validatePeerCertificate(1, certificate);
        }
    }

    public void processClientKeyExchange(InputStream inputStream) throws IOException {
        if (this.ecdhPeerCertificate != null) {
            return;
        }
        byte[] byArray = TlsUtils.readOpaque8(inputStream);
        this.processEphemeral(this.serverECPointFormats, byArray);
    }

    public TlsSecret generatePreMasterSecret() throws IOException {
        if (this.agreementCredentials != null) {
            return this.agreementCredentials.generateAgreement(this.ecdhPeerCertificate);
        }
        if (this.agreement != null) {
            return this.agreement.calculateSecret();
        }
        throw new TlsFatalAlert(80);
    }

    protected void generateEphemeral(OutputStream outputStream) throws IOException {
        byte[] byArray = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque8(byArray, outputStream);
    }

    protected void processEphemeral(short[] sArray, byte[] byArray) throws IOException {
        TlsECCUtils.checkPointEncoding(sArray, this.ecConfig.getNamedCurve(), byArray);
        this.agreement.receivePeerValue(byArray);
    }

    protected TlsCertificate validatePeerCertificate(int n, Certificate certificate) throws IOException {
        if (certificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        return certificate.getCertificateAt(0).useInRole(n, this.keyExchange);
    }
}

