/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.manager;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.manager.SnmpPeer;
import com.sun.management.snmp.manager.SnmpResponseHandler;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

final class SnmpSocket
implements Runnable {
    int responseBufSize = SnmpPeer.defaultSnmpResponsePktSize;
    int _socketPort = 0;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpSocket");
    String dbgTag = "SnmpSocket";
    boolean isBeingDestroyed = false;
    private int _pktsSent = 0;
    private int _pktsRecvd = 0;
    private int _errors = 0;
    private final SnmpResponseHandler _dgramHdlr;
    private Thread _sockThread = null;
    private transient boolean isClosing = false;
    private DatagramSocket _socket;
    private byte[] _buffer = null;

    public SnmpSocket(SnmpResponseHandler rspHdlr) throws SocketException {
        this(rspHdlr, null, 0);
    }

    public SnmpSocket(SnmpResponseHandler rspHdlr, InetAddress addr, int port) throws SocketException {
        if (logger.finerOn()) {
            logger.finer("constructor", "Creating new SNMP datagram socket");
        }
        this._socket = addr == null ? new DatagramSocket() : new DatagramSocket(port, addr);
        this._socketPort = this._socket.getLocalPort();
        this._buffer = new byte[this.responseBufSize];
        this._dgramHdlr = rspHdlr;
        this._sockThread = new Thread(this);
        this._sockThread.start();
    }

    public final synchronized int getPktsErrors() {
        return this._errors;
    }

    public final synchronized int getInPkts() {
        return this._pktsRecvd;
    }

    public final synchronized int getOutPkts() {
        return this._pktsSent;
    }

    public final synchronized void performResetPktStatistics() {
        this._pktsSent = 0;
        this._pktsRecvd = 0;
        this._errors = 0;
    }

    public synchronized String toString() {
        String s = "SnmpSocket : ";
        s = this.isValid() ? s + this._socket.toString() : s + "Socket invalid state. ";
        s = s + " Pkts Sent = " + this._pktsSent + " Pkts Recvd = " + this._pktsRecvd + " Errors = " + this._errors;
        return s;
    }

    public final int getResponsePktSize() {
        return this.responseBufSize;
    }

    public final synchronized void setResponsePktSize(int size) {
        if (this.responseBufSize != size) {
            this.responseBufSize = size;
            this._buffer = new byte[this.responseBufSize];
        }
    }

    public synchronized void sendPacket(byte[] buff, int length, InetAddress addr, int port) throws IOException {
        DatagramPacket dgrmpkt = new DatagramPacket(buff, length, addr, port);
        this.sendPacket(dgrmpkt);
    }

    public synchronized void sendPacket(DatagramPacket dgrmpkt) throws IOException {
        block5: {
            try {
                if (this.isValid()) {
                    if (logger.finerOn()) {
                        logger.finer("sendPacket", "Sending DatagramPacket. Length = " + dgrmpkt.getLength() + " through socket = " + this._socket.toString());
                    }
                    this._socket.send(dgrmpkt);
                    ++this._pktsSent;
                    break block5;
                }
                throw new IOException("Invalid state of SNMP datagram socket.");
            }
            catch (IOException e) {
                if (logger.finestOn()) {
                    logger.finest("sendPacket", "Io error while sending");
                    logger.finest("sendPacket", e);
                }
                ++this._errors;
                throw e;
            }
        }
    }

    public synchronized boolean isValid() {
        return this._socket != null && this._sockThread != null && this._sockThread.isAlive();
    }

    public synchronized void close() {
        this.isClosing = true;
        if (logger.finerOn()) {
            logger.finer("close", "Closing and destroying the SNMP datagram socket -> " + this.toString());
        }
        try {
            DatagramSocket sn = new DatagramSocket(0);
            byte[] ob = new byte[1];
            DatagramPacket pk = new DatagramPacket(ob, 1, InetAddress.getLocalHost(), this._socketPort);
            sn.send(pk);
            sn.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this._socket != null) {
            this._socket.close();
            this._socket = null;
        }
        if (this._sockThread != null && this._sockThread.isAlive()) {
            this._sockThread.interrupt();
            try {
                this._sockThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._sockThread = null;
        }
    }

    private synchronized void handleJavaError(Throwable thr) {
        if (thr instanceof OutOfMemoryError) {
            if (logger.finestOn()) {
                logger.finest("handleJavaError", thr);
            }
            Thread.currentThread();
            Thread.yield();
            return;
        }
        if (this._socket != null) {
            this._socket.close();
            this._socket = null;
        }
        if (logger.finestOn()) {
            logger.finest("handleJavaError", "Global Internal error");
        }
        Thread.currentThread();
        Thread.yield();
    }

    public void run() {
        Thread.currentThread().setPriority(8);
        block5: while (true) {
            try {
                while (true) {
                    DatagramPacket dgrmpkt = new DatagramPacket(this._buffer, this._buffer.length);
                    if (logger.finerOn()) {
                        logger.finer("run", "[" + Thread.currentThread().toString() + "]:" + "Blocking for receiving packet");
                    }
                    this._socket.receive(dgrmpkt);
                    if (this.isBeingDestroyed || this.isClosing) break block5;
                    ++this._pktsRecvd;
                    if (logger.finerOn()) {
                        logger.finer("run", "[" + Thread.currentThread().toString() + "]:" + "Received a packet");
                    }
                    if (dgrmpkt.getLength() <= 0) continue;
                    if (logger.finerOn()) {
                        logger.finer("run", "[" + Thread.currentThread().toString() + "]:" + "Received a packet from : " + dgrmpkt.getAddress().toString() + ", Length = " + dgrmpkt.getLength());
                    }
                    this.handleDatagram(dgrmpkt);
                    if (this.isClosing) break;
                }
            }
            catch (IOException io) {
                if (this.isClosing) break;
                ++this._errors;
                if (!logger.finestOn()) continue;
                logger.finest("run", io);
                continue;
            }
            catch (Exception e) {
                if (this.isClosing) break;
                ++this._errors;
                if (!logger.finestOn()) continue;
                logger.finest("run", "Exception in socket thread...");
                logger.finest("run", e);
                continue;
            }
            catch (ThreadDeath d) {
                ++this._errors;
                if (logger.finestOn()) {
                    logger.finest("run", "Socket Thread DEAD..." + this.toString());
                    logger.finest("run", d);
                }
                this.close();
                throw d;
            }
            catch (Error err) {
                ++this._errors;
                if (logger.finestOn()) {
                    logger.finest("run", err);
                }
                this.handleJavaError(err);
                continue;
            }
            break;
        }
    }

    private void handleDatagram(DatagramPacket dgrmpkt) {
        this._dgramHdlr.processDatagram(dgrmpkt);
    }

    public synchronized void finalize() {
        this.close();
    }
}

