/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp;

import com.sun.jdmk.defaults.Utils;
import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.BerDecoder;
import com.sun.management.snmp.BerEncoder;
import com.sun.management.snmp.BerException;
import com.sun.management.snmp.SnmpDefinitions;
import com.sun.management.snmp.SnmpIpAddress;
import com.sun.management.snmp.SnmpMsg;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduBulk;
import com.sun.management.snmp.SnmpPduPacket;
import com.sun.management.snmp.SnmpPduRequest;
import com.sun.management.snmp.SnmpPduTrap;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpTooBigException;
import com.sun.management.snmp.SnmpVarBind;

public class SnmpMessage
extends SnmpMsg
implements SnmpDefinitions {
    public byte[] community;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpMessage");
    String dbgTag = "SnmpMessage";

    public int encodeMessage(byte[] outputBytes) throws SnmpTooBigException {
        int encodingLength = 0;
        if (this.data == null) {
            throw new IllegalArgumentException("Data field is null");
        }
        try {
            BerEncoder benc = new BerEncoder(outputBytes);
            benc.openSequence();
            benc.putAny(this.data, this.dataLength);
            benc.putOctetString(this.community != null ? this.community : new byte[]{});
            benc.putInteger(this.version);
            benc.closeSequence();
            encodingLength = benc.trim();
        }
        catch (ArrayIndexOutOfBoundsException x) {
            throw new SnmpTooBigException();
        }
        return encodingLength;
    }

    public int getRequestId(byte[] inputBytes) throws SnmpStatusException {
        int requestId = 0;
        BerDecoder bdec = null;
        BerDecoder bdec2 = null;
        byte[] any = null;
        try {
            bdec = new BerDecoder(inputBytes);
            bdec.openSequence();
            bdec.fetchInteger();
            bdec.fetchOctetString();
            any = bdec.fetchAny();
            bdec2 = new BerDecoder(any);
            int type = bdec2.getTag();
            bdec2.openSequence(type);
            requestId = bdec2.fetchInteger();
        }
        catch (BerException x) {
            throw new SnmpStatusException("Invalid encoding");
        }
        try {
            bdec.closeSequence();
        }
        catch (BerException x) {
            // empty catch block
        }
        try {
            bdec2.closeSequence();
        }
        catch (BerException x) {
            // empty catch block
        }
        return requestId;
    }

    public void decodeMessage(byte[] inputBytes, int byteCount) throws SnmpStatusException {
        try {
            BerDecoder bdec = new BerDecoder(inputBytes);
            bdec.openSequence();
            this.version = bdec.fetchInteger();
            this.community = bdec.fetchOctetString();
            this.data = bdec.fetchAny();
            this.dataLength = this.data.length;
            bdec.closeSequence();
        }
        catch (BerException x) {
            throw new SnmpStatusException("Invalid encoding");
        }
    }

    public void encodeSnmpPdu(SnmpPdu pdu, int maxDataLength) throws SnmpStatusException, SnmpTooBigException {
        SnmpPduPacket pdupacket = (SnmpPduPacket)pdu;
        this.version = pdupacket.version;
        this.community = pdupacket.community;
        this.address = pdupacket.address;
        this.port = pdupacket.port;
        this.data = new byte[maxDataLength];
        try {
            BerEncoder benc = new BerEncoder(this.data);
            benc.openSequence();
            this.encodeVarBindList(benc, pdupacket.varBindList);
            switch (pdupacket.type) {
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 166: 
                case 167: 
                case 168: {
                    SnmpPduRequest reqPdu = (SnmpPduRequest)pdupacket;
                    benc.putInteger(reqPdu.errorIndex);
                    benc.putInteger(reqPdu.errorStatus);
                    benc.putInteger(reqPdu.requestId);
                    break;
                }
                case 165: {
                    SnmpPduBulk bulkPdu = (SnmpPduBulk)pdupacket;
                    benc.putInteger(bulkPdu.maxRepetitions);
                    benc.putInteger(bulkPdu.nonRepeaters);
                    benc.putInteger(bulkPdu.requestId);
                    break;
                }
                case 164: {
                    SnmpPduTrap trapPdu = (SnmpPduTrap)pdupacket;
                    benc.putInteger(trapPdu.timeStamp, 67);
                    benc.putInteger(trapPdu.specificTrap);
                    benc.putInteger(trapPdu.genericTrap);
                    if (trapPdu.agentAddr != null) {
                        benc.putOctetString(trapPdu.agentAddr.byteValue(), 64);
                    } else {
                        benc.putOctetString(new byte[0], 64);
                    }
                    benc.putOid(trapPdu.enterprise.longValue());
                    break;
                }
                default: {
                    throw new SnmpStatusException("Invalid pdu type " + String.valueOf(pdupacket.type));
                }
            }
            benc.closeSequence(pdupacket.type);
            this.dataLength = benc.trim();
        }
        catch (ArrayIndexOutOfBoundsException x) {
            SnmpVarBind[] vbl = pdupacket.varBindList;
            int index = vbl == null || vbl.length == 0 ? 0 : vbl.length - 1;
            SnmpTooBigException tooBig = new SnmpTooBigException(index);
            try {
                Utils.initCause(tooBig, x);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw tooBig;
        }
    }

    public SnmpPdu decodeSnmpPdu() throws SnmpStatusException {
        SnmpPduPacket pdu = null;
        BerDecoder bdec = new BerDecoder(this.data);
        try {
            int type = bdec.getTag();
            bdec.openSequence(type);
            switch (type) {
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 166: 
                case 167: 
                case 168: {
                    SnmpPduRequest reqPdu = new SnmpPduRequest();
                    reqPdu.requestId = bdec.fetchInteger();
                    reqPdu.errorStatus = bdec.fetchInteger();
                    reqPdu.errorIndex = bdec.fetchInteger();
                    pdu = reqPdu;
                    break;
                }
                case 165: {
                    SnmpPduBulk bulkPdu = new SnmpPduBulk();
                    bulkPdu.requestId = bdec.fetchInteger();
                    bulkPdu.nonRepeaters = bdec.fetchInteger();
                    bulkPdu.maxRepetitions = bdec.fetchInteger();
                    pdu = bulkPdu;
                    break;
                }
                case 164: {
                    SnmpPduTrap trapPdu = new SnmpPduTrap();
                    trapPdu.enterprise = new SnmpOid(bdec.fetchOid());
                    byte[] b = bdec.fetchOctetString(64);
                    trapPdu.agentAddr = b.length != 0 ? new SnmpIpAddress(b) : null;
                    trapPdu.genericTrap = bdec.fetchInteger();
                    trapPdu.specificTrap = bdec.fetchInteger();
                    trapPdu.timeStamp = bdec.fetchInteger(67);
                    pdu = trapPdu;
                    break;
                }
                default: {
                    throw new SnmpStatusException(9);
                }
            }
            pdu.type = type;
            pdu.varBindList = this.decodeVarBindList(bdec);
            bdec.closeSequence();
        }
        catch (BerException e) {
            if (logger.finestOn()) {
                logger.finest("decodeSnmpPdu", e);
            }
            throw new SnmpStatusException(9);
        }
        catch (IllegalArgumentException e) {
            if (logger.finestOn()) {
                logger.finest("decodeSnmpPdu", e);
            }
            throw new SnmpStatusException(9);
        }
        pdu.version = this.version;
        pdu.community = this.community;
        pdu.address = this.address;
        pdu.port = this.port;
        return pdu;
    }

    public String printMessage() {
        StringBuffer sb = new StringBuffer();
        if (this.community == null) {
            sb.append("Community: null");
        } else {
            sb.append("Community: {\n");
            sb.append(SnmpMessage.dumpHexBuffer(this.community, 0, this.community.length));
            sb.append("\n}\n");
        }
        return sb.append(super.printMessage()).toString();
    }
}

