/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.IPAcl;

import com.sun.jdmk.defaults.DefaultPaths;
import com.sun.jdmk.defaults.Utils;
import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.IPAcl.AclEntryImpl;
import com.sun.management.snmp.IPAcl.AclImpl;
import com.sun.management.snmp.IPAcl.JDMSecurityDefs;
import com.sun.management.snmp.IPAcl.ParseException;
import com.sun.management.snmp.IPAcl.Parser;
import com.sun.management.snmp.IPAcl.PermissionImpl;
import com.sun.management.snmp.IPAcl.PrincipalImpl;
import com.sun.management.snmp.InetAddressAcl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class JdmkAcl
implements InetAddressAcl,
Serializable {
    private static final long serialVersionUID = -1731776149894734768L;
    static final PermissionImpl READ = new PermissionImpl("READ");
    static final PermissionImpl WRITE = new PermissionImpl("WRITE");
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "JdmkAcl");
    String dbgTag;
    private AclImpl acl;
    private boolean alwaysAuthorized;
    private String authorizedListFile;
    private Hashtable trapDestList;
    private Hashtable informDestList;
    private PrincipalImpl owner;

    public JdmkAcl(String name, String fileName) throws UnknownHostException, IllegalArgumentException {
        block4: {
            this.dbgTag = "JdmkAcl";
            this.acl = null;
            this.alwaysAuthorized = false;
            this.authorizedListFile = null;
            this.trapDestList = null;
            this.informDestList = null;
            this.owner = null;
            this.trapDestList = new Hashtable();
            this.informDestList = new Hashtable();
            this.owner = new PrincipalImpl();
            try {
                this.acl = new AclImpl(this.owner, name);
                AclEntryImpl ownEntry = new AclEntryImpl(this.owner);
                ownEntry.addPermission(READ);
                ownEntry.addPermission(WRITE);
                this.acl.addEntry(this.owner, ownEntry);
            }
            catch (NotOwnerException ex) {
                if (!logger.finestOn()) break block4;
                logger.finest("constructor", "Should never get NotOwnerException as the owner is built in this constructor");
            }
        }
        if (fileName == null) {
            this.setDefautFileName();
        } else {
            this.authorizedListFile = fileName;
        }
        this.readAuthorisedListFile();
    }

    public JdmkAcl(String name) throws UnknownHostException, IllegalArgumentException {
        this(name, null);
    }

    public synchronized Enumeration entries() {
        return this.acl.entries();
    }

    public synchronized Enumeration communities() {
        HashSet<String> set = new HashSet<String>();
        Vector<Object> res = new Vector<Object>();
        Enumeration e = this.acl.entries();
        while (e.hasMoreElements()) {
            AclEntryImpl entry = (AclEntryImpl)e.nextElement();
            Enumeration cs = entry.communities();
            while (cs.hasMoreElements()) {
                set.add((String)cs.nextElement());
            }
        }
        Object[] objs = set.toArray();
        for (int i = 0; i < objs.length; ++i) {
            res.addElement(objs[i]);
        }
        return res.elements();
    }

    public synchronized String getName() {
        return this.acl.getName();
    }

    public static PermissionImpl getREAD() {
        return READ;
    }

    public static PermissionImpl getWRITE() {
        return WRITE;
    }

    public synchronized void setAuthorizedListFile(String filename) throws IllegalArgumentException, NotOwnerException, UnknownHostException {
        if (filename == null) {
            throw new IllegalArgumentException("The specified file is null");
        }
        File file = new File(filename);
        if (!file.isFile()) {
            if (logger.finestOn()) {
                logger.finest("setAuthorizedListFile", "Ip ACL file not found. Wrong passed file : " + filename);
            }
            throw new IllegalArgumentException("The specified file [" + file + "] doesn't exist or is not a file, no configuration loaded");
        }
        if (logger.finerOn()) {
            logger.finer("setAuthorizedListFile", "Default file set to " + filename);
        }
        this.authorizedListFile = filename;
        this.rereadTheFile();
    }

    public synchronized void rereadTheFile() throws NotOwnerException, UnknownHostException {
        this.alwaysAuthorized = false;
        this.acl.removeAll(this.owner);
        this.trapDestList.clear();
        this.informDestList.clear();
        AclEntryImpl ownEntry = new AclEntryImpl(this.owner);
        ownEntry.addPermission(READ);
        ownEntry.addPermission(WRITE);
        this.acl.addEntry(this.owner, ownEntry);
        this.readAuthorisedListFile();
    }

    public synchronized String getAuthorizedListFile() {
        return this.authorizedListFile;
    }

    public synchronized boolean checkReadPermission(InetAddress address) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl p = new PrincipalImpl(address);
        return this.acl.checkPermission(p, READ);
    }

    public synchronized boolean checkReadPermission(InetAddress address, String community) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl p = new PrincipalImpl(address);
        return this.acl.checkPermission(p, community, READ);
    }

    public synchronized boolean checkCommunity(String community) {
        return this.acl.checkCommunity(community);
    }

    public synchronized boolean checkWritePermission(InetAddress address) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl p = new PrincipalImpl(address);
        return this.acl.checkPermission(p, WRITE);
    }

    public synchronized boolean checkWritePermission(InetAddress address, String community) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl p = new PrincipalImpl(address);
        return this.acl.checkPermission(p, community, WRITE);
    }

    public synchronized Enumeration getTrapDestinations() {
        return this.trapDestList.keys();
    }

    public synchronized Enumeration getTrapCommunities(InetAddress i) {
        Vector list = null;
        list = (Vector)this.trapDestList.get(i);
        if (list != null) {
            if (logger.finerOn()) {
                logger.finer("getTrapCommunities", "[" + i.toString() + "] is in list");
            }
            return list.elements();
        }
        list = new Vector();
        if (logger.finerOn()) {
            logger.finer("getTrapCommunities", "[" + i.toString() + "] is not in list");
        }
        return list.elements();
    }

    public synchronized Enumeration getInformDestinations() {
        return this.informDestList.keys();
    }

    public synchronized Enumeration getInformCommunities(InetAddress i) {
        Vector list = null;
        list = (Vector)this.informDestList.get(i);
        if (list != null) {
            if (logger.finerOn()) {
                logger.finer("getInformCommunities", "[" + i.toString() + "] is in list");
            }
            return list.elements();
        }
        list = new Vector();
        if (logger.finerOn()) {
            logger.finer("getInformCommunities", "[" + i.toString() + "] is not in list");
        }
        return list.elements();
    }

    private static void checkCanRead(String f) throws IllegalArgumentException {
        File file = new File(f);
        if (file.isFile() && !file.canRead()) {
            throw new IllegalArgumentException("IP ACL file is not readable.");
        }
    }

    private void readAuthorisedListFile() {
        this.alwaysAuthorized = false;
        if (this.authorizedListFile == null) {
            if (logger.finerOn()) {
                logger.finer("readAuthorisedListFile", "alwaysAuthorized set to true");
            }
            this.alwaysAuthorized = true;
        } else {
            Parser parser = null;
            try {
                JdmkAcl.checkCanRead(this.getAuthorizedListFile());
                parser = new Parser(new FileInputStream(this.getAuthorizedListFile()));
            }
            catch (FileNotFoundException e) {
                if (logger.finestOn()) {
                    logger.finest("readAuthorisedListFile", "The specified file was not found, authorize everybody");
                }
                this.alwaysAuthorized = true;
                return;
            }
            try {
                JDMSecurityDefs n = parser.SecurityDefs();
                n.buildAclEntries(this.owner, this.acl);
                n.buildTrapEntries(this.trapDestList);
                n.buildInformEntries(this.informDestList);
            }
            catch (ParseException e) {
                if (logger.finestOn()) {
                    logger.finest("readAuthorisedListFile", "Parsing exception " + e);
                }
                IllegalArgumentException iae = new IllegalArgumentException("Syntax error: " + e);
                Utils.initCause(iae, e);
                throw iae;
            }
            catch (Error err) {
                if (logger.finestOn()) {
                    logger.finest("readAuthorisedListFile", "Error exception " + err);
                }
                IllegalArgumentException iae = new IllegalArgumentException("Error: " + err);
                Utils.initCause(iae, err);
                throw iae;
            }
            Enumeration e = this.acl.entries();
            while (e.hasMoreElements()) {
                AclEntryImpl aa = (AclEntryImpl)e.nextElement();
                if (logger.finerOn()) {
                    logger.finer("readAuthorisedListFile", "===> " + ((Object)aa.getPrincipal()).toString());
                }
                Enumeration eee = aa.permissions();
                while (eee.hasMoreElements()) {
                    Permission perm = (Permission)eee.nextElement();
                    if (!logger.finerOn()) continue;
                    logger.finer("readAuthorisedListFile", "perm = " + perm);
                }
            }
        }
    }

    private void setDefautFileName() throws IllegalArgumentException {
        String aclFile = null;
        File file = null;
        aclFile = System.getProperty("jdmk.acl.file");
        if (aclFile == null) {
            aclFile = DefaultPaths.getEtcDir("conf" + File.separator + "jdmk.acl");
            if (logger.finestOn()) {
                logger.finest("setDefautFileName", "Default File name is : " + aclFile);
            }
            if ((file = new File(aclFile)).isFile()) {
                if (logger.finerOn()) {
                    logger.finer("setDefautFileName", "Default Ip ACL file found : " + aclFile);
                }
            } else if (logger.finestOn()) {
                logger.finest("setDefautFileName", "Default Ip ACL file not found.");
            }
        } else {
            file = new File(aclFile);
            if (!file.isFile()) {
                if (logger.finestOn()) {
                    logger.finest("setDefautFileName", "Ip ACL file not found. Wrong java property : jdmk.acl.file=" + aclFile);
                }
                throw new IllegalArgumentException("The specified file [" + file + "] doesn't exist or is not a file, no configuration loaded");
            }
            if (logger.finerOn()) {
                logger.finer("setDefautFileName", "Ip ACL file found : " + aclFile);
            }
        }
        this.authorizedListFile = aclFile;
    }
}

