/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp;

public class BerEncoder {
    public static final int BooleanTag = 1;
    public static final int IntegerTag = 2;
    public static final int OctetStringTag = 4;
    public static final int NullTag = 5;
    public static final int OidTag = 6;
    public static final int SequenceTag = 48;
    protected final byte[] bytes;
    protected int start = -1;
    protected final int[] stackBuf = new int[200];
    protected int stackTop = 0;

    public BerEncoder(byte[] b) {
        this.bytes = b;
        this.start = b.length;
        this.stackTop = 0;
    }

    public int trim() {
        int result = this.bytes.length - this.start;
        if (result > 0) {
            System.arraycopy(this.bytes, this.start, this.bytes, 0, result);
        }
        this.start = this.bytes.length;
        this.stackTop = 0;
        return result;
    }

    public void putInteger(int v) {
        this.putInteger(v, 2);
    }

    public void putInteger(int v, int tag) {
        this.putIntegerValue(v);
        this.putTag(tag);
    }

    public void putInteger(long v) {
        this.putInteger(v, 2);
    }

    public void putInteger(long v, int tag) {
        this.putIntegerValue(v);
        this.putTag(tag);
    }

    public void putOctetString(byte[] s) {
        this.putOctetString(s, 4);
    }

    public void putOctetString(byte[] s, int tag) {
        this.putStringValue(s);
        this.putTag(tag);
    }

    public void putOid(long[] s) {
        this.putOid(s, 6);
    }

    public void putOid(long[] s, int tag) {
        this.putOidValue(s);
        this.putTag(tag);
    }

    public void putNull() {
        this.putNull(5);
    }

    public void putNull(int tag) {
        this.putLength(0);
        this.putTag(tag);
    }

    public void putAny(byte[] s) {
        this.putAny(s, s.length);
    }

    public void putAny(byte[] s, int byteCount) {
        System.arraycopy(s, 0, this.bytes, this.start - byteCount, byteCount);
        this.start -= byteCount;
    }

    public void putUnsignedLong(long v, int tag) {
        this.putUnsignedLongValue(v);
        this.putTag(tag);
    }

    public void openSequence() {
        this.stackBuf[this.stackTop++] = this.start;
    }

    public void closeSequence() {
        this.closeSequence(48);
    }

    public void closeSequence(int tag) {
        int end = this.stackBuf[--this.stackTop];
        this.putLength(end - this.start);
        this.putTag(tag);
    }

    protected final void putTag(int tag) {
        if (tag < 256) {
            this.bytes[--this.start] = (byte)tag;
        } else {
            while (tag != 0) {
                this.bytes[--this.start] = (byte)(tag & 0x7F);
                tag <<= 7;
            }
        }
    }

    protected final void putLength(int length) {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        if (length < 128) {
            this.bytes[--this.start] = (byte)length;
        } else if (length < 256) {
            this.bytes[--this.start] = (byte)length;
            this.bytes[--this.start] = -127;
        } else if (length < 65536) {
            this.bytes[--this.start] = (byte)length;
            this.bytes[--this.start] = (byte)(length >> 8);
            this.bytes[--this.start] = -126;
        } else if (length < 0xFFFFA6) {
            this.bytes[--this.start] = (byte)length;
            this.bytes[--this.start] = (byte)(length >> 8);
            this.bytes[--this.start] = (byte)(length >> 16);
            this.bytes[--this.start] = -125;
        } else {
            this.bytes[--this.start] = (byte)length;
            this.bytes[--this.start] = (byte)(length >> 8);
            this.bytes[--this.start] = (byte)(length >> 16);
            this.bytes[--this.start] = (byte)(length >> 24);
            this.bytes[--this.start] = -124;
        }
    }

    protected final void putIntegerValue(int v) {
        int byteNeeded;
        int end = this.start;
        int mask = 2139095040;
        if (v < 0) {
            for (byteNeeded = 4; (mask & v) == mask && byteNeeded > 1; mask >>= 8, --byteNeeded) {
            }
        } else {
            while ((mask & v) == 0 && byteNeeded > 1) {
                mask >>= 8;
                --byteNeeded;
            }
        }
        for (int i = 0; i < byteNeeded; ++i) {
            this.bytes[--this.start] = (byte)v;
            v >>= 8;
        }
        this.putLength(end - this.start);
    }

    protected final void putIntegerValue(long v) {
        int byteNeeded;
        int end = this.start;
        long mask = 9187343239835811840L;
        if (v < 0L) {
            for (byteNeeded = 8; (mask & v) == mask && byteNeeded > 1; mask >>= 8, --byteNeeded) {
            }
        } else {
            while ((mask & v) == 0L && byteNeeded > 1) {
                mask >>= 8;
                --byteNeeded;
            }
        }
        for (int i = 0; i < byteNeeded; ++i) {
            this.bytes[--this.start] = (byte)v;
            v >>= 8;
        }
        this.putLength(end - this.start);
    }

    protected void putUnsignedLongValue(long v) {
        int end = this.start;
        long mask = 9187343239835811840L;
        if (v < 0L) {
            int byteNeeded = 9;
            for (int i = 0; i < byteNeeded; ++i) {
                this.bytes[--this.start] = (byte)v;
                v >>= 8;
            }
        } else {
            int byteNeeded;
            for (byteNeeded = 8; (mask & v) == 0L && byteNeeded > 1; --byteNeeded) {
                mask >>= 8;
            }
            for (int i = 0; i < byteNeeded; ++i) {
                this.bytes[--this.start] = (byte)v;
                v >>= 8;
            }
        }
        this.putLength(end - this.start);
    }

    protected final void putStringValue(byte[] s) {
        int datalen = s.length;
        System.arraycopy(s, 0, this.bytes, this.start - datalen, datalen);
        this.start -= datalen;
        this.putLength(datalen);
    }

    protected final void putOidValue(long[] s) {
        int end = this.start;
        int slength = s.length;
        if (slength < 2 || s[0] > 2L || s[1] >= 40L) {
            throw new IllegalArgumentException();
        }
        for (int i = slength - 1; i >= 2; --i) {
            long c = s[i];
            if (c < 0L) {
                throw new IllegalArgumentException();
            }
            if (c < 128L) {
                this.bytes[--this.start] = (byte)c;
                continue;
            }
            this.bytes[--this.start] = (byte)(c & 0x7FL);
            c >>= 7;
            while (c != 0L) {
                this.bytes[--this.start] = (byte)(c | 0x80L);
                c >>= 7;
            }
        }
        this.bytes[--this.start] = (byte)(s[0] * 40L + s[1]);
        this.putLength(end - this.start);
    }
}

