/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.management.comm.SnmpInformRequest;
import com.sun.management.comm.SnmpQManager;
import java.util.Vector;

class SendQ
extends Vector {
    private static final long serialVersionUID = 6030955773350706204L;
    boolean isBeingDestroyed = false;

    SendQ(int initialCapacity, int capacityIncr) {
        super(initialCapacity, capacityIncr);
    }

    private synchronized void notifyClients() {
        this.notifyAll();
    }

    public synchronized void addRequest(SnmpInformRequest req) {
        int i;
        long nextPoll = req.getAbsNextPollTime();
        for (i = this.size(); i > 0 && nextPoll >= this.getRequestAt(i - 1).getAbsNextPollTime(); --i) {
        }
        if (i == this.size()) {
            this.addElement(req);
            this.notifyClients();
        } else {
            this.insertElementAt(req, i);
        }
    }

    public synchronized boolean waitUntilReady() {
        while (!this.isBeingDestroyed) {
            long tmp = 0L;
            if (!this.isEmpty()) {
                long currTime = System.currentTimeMillis();
                SnmpInformRequest req = (SnmpInformRequest)this.lastElement();
                tmp = req.getAbsNextPollTime() - currTime;
                if (tmp <= 0L) {
                    return true;
                }
            }
            this.waitOnThisQueue(tmp);
        }
        return false;
    }

    public synchronized Vector getAllOutstandingRequest(long margin) {
        Vector<SnmpInformRequest> outreq = new Vector<SnmpInformRequest>();
        while (this.waitUntilReady()) {
            SnmpInformRequest req;
            long refTime = System.currentTimeMillis() + margin;
            for (int i = this.size(); i > 0 && (req = this.getRequestAt(i - 1)).getAbsNextPollTime() <= refTime; --i) {
                outreq.addElement(req);
            }
            if (outreq.isEmpty()) continue;
            this.elementCount -= outreq.size();
            return outreq;
        }
        return null;
    }

    public synchronized void waitOnThisQueue(long time) {
        if (time == 0L && !this.isEmpty() && SnmpQManager.logger.finestOn()) {
            SnmpQManager.logger.finest("waitOnThisQueue", "[" + Thread.currentThread().toString() + "]:" + "Fatal BUG :: Blocking on newq permenantly. " + "But size = " + this.size());
        }
        try {
            this.wait(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public SnmpInformRequest getRequestAt(int idx) {
        return (SnmpInformRequest)this.elementAt(idx);
    }

    public synchronized SnmpInformRequest removeRequest(long reqid) {
        int max = this.size();
        for (int i = 0; i < max; ++i) {
            SnmpInformRequest reqc = this.getRequestAt(i);
            if (reqid != (long)reqc.getRequestId()) continue;
            this.removeElementAt(i);
            return reqc;
        }
        return null;
    }
}

