/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.HeartBeatServerHandler;
import com.sun.jdmk.comm.ServerNotificationDispatcher;
import com.sun.jdmk.internal.ClassLogger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;

abstract class RmiConnectorServerObjectCommon
extends UnicastRemoteObject {
    final ClassLogger logger = new ClassLogger("com.sun.jdmk.comm.legacy.connector.rmi", ClassLogger.getClassName(this.getClass()));
    private String host;
    private String serviceName = null;
    private int port;
    private boolean isActive = false;
    ServerNotificationDispatcher serverNotificationDispatcher = null;
    HeartBeatServerHandler heartbeatServerHandler = null;

    public RmiConnectorServerObjectCommon(String serviceName, int port, ServerNotificationDispatcher serverNotificationDispatcher, HeartBeatServerHandler heartbeatServerHandler) throws RemoteException {
        if (System.getProperty("jdmk.hostname") != null) {
            this.host = System.getProperty("jdmk.hostname");
        } else {
            try {
                this.host = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                this.host = "localhost";
            }
        }
        if (this.logger.finerOn()) {
            this.logger.finer("RmiConnectorServerObjectCommon", "host=" + this.host);
        }
        this.serviceName = serviceName;
        this.port = port;
        this.serviceName = RmiConnectorServerObjectCommon.makeManagedObjFactoryName(this.host, port, serviceName);
        this.serverNotificationDispatcher = serverNotificationDispatcher;
        this.heartbeatServerHandler = heartbeatServerHandler;
    }

    static String makeManagedObjFactoryName(String host, int port, String name) {
        return "rmi://:" + port + "/" + name;
    }

    void bind() throws CommunicationException, RemoteException {
        Registry r = null;
        try {
            if (this.logger.finerOn()) {
                this.logger.finer("bind", "Register object in RmiRegistry ; name=" + this.serviceName);
            }
            Naming.bind(this.serviceName, this);
            if (this.logger.finerOn()) {
                this.logger.finer("bind", "Done");
            }
        }
        catch (AlreadyBoundException e) {
            throw new CommunicationException(e, "Failed to register " + this.serviceName);
        }
        catch (MalformedURLException e) {
            throw new CommunicationException(e, "Failed to register " + this.serviceName);
        }
        catch (AccessException e) {
            throw new CommunicationException(e, "Failed to register " + this.serviceName);
        }
        catch (RemoteException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("bind", "Failed to bind:" + e);
            }
            if (this.logger.finerOn()) {
                this.logger.finer("bind", "Create Rmi registry port=" + this.port);
            }
            r = LocateRegistry.createRegistry(this.port);
            if (this.logger.finerOn()) {
                this.logger.finer("bind", "Creation done");
            }
            try {
                if (this.logger.finerOn()) {
                    this.logger.finer("bind", "Register object in RmiRegistry ; name=" + this.serviceName);
                }
                Naming.bind(this.serviceName, this);
                if (this.logger.finerOn()) {
                    this.logger.finer("bind", "Done");
                }
            }
            catch (Exception x) {
                throw new CommunicationException(x, "Failed to register " + this.serviceName);
            }
        }
        this.isActive = true;
    }

    void unbind() {
        try {
            if (this.logger.finestOn()) {
                this.logger.finest("unbind", "Unregister object in RmiRegistry ; name=" + this.serviceName);
            }
            Naming.unbind(this.serviceName);
            if (this.logger.finestOn()) {
                this.logger.finest("unbind", "Done");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isActive = false;
    }

    void stopIfNotActive(String methodName) throws RemoteException {
        if (!this.isActive) {
            if (this.logger.finerOn()) {
                this.logger.finer(methodName, "Connector is OFFLINE.");
            }
            throw new RemoteException("Connector is OFFLINE.");
        }
    }
}

