/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.processors;

import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.annotations.TigaseDeprecated;
import tigase.archive.MessageArchiveVHostItemExtension;
import tigase.archive.RetentionType;
import tigase.archive.Settings;
import tigase.archive.StoreMethod;
import tigase.archive.StoreMuc;
import tigase.archive.processors.MessageArchivePlugin;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.JID;

@TigaseDeprecated(since="3.0.0", note="XEP-0136 support will be removed in future version")
@Deprecated
@Bean(name="message-archive-xep-0136", parent=SessionManager.class, active=false)
public class Xep0136MessageArchivingProcessor
extends XMPPProcessor
implements XMPPProcessorIfc {
    public static final String MUC_SAVE = "muc-save";
    public static final String LIST = "list";
    public static final String REMOVE = "remove";
    public static final String RETRIEVE = "retrieve";
    public static final String XEP0136NS = "urn:xmpp:archive";
    protected static final String AUTO = "auto";
    protected static final String ID = "message-archive-xep-0136";
    protected static final String SETTINGS = "message-archive/settings";
    private static final String EXPIRE = "expire";
    private static final Logger log = Logger.getLogger(Xep0136MessageArchivingProcessor.class.getCanonicalName());
    private static final String SAVE = "save";
    private static final String[][] ELEMENT_PATHS = new String[][]{{"iq", "auto"}, {"iq", "retrieve"}, {"iq", "list"}, {"iq", "remove"}, {"iq", "save"}, {"iq", "pref"}, {"iq", "tags"}};
    private static final String[] XMLNSS = new String[]{"urn:xmpp:archive", "urn:xmpp:archive", "urn:xmpp:archive", "urn:xmpp:archive", "urn:xmpp:archive", "urn:xmpp:archive", "http://tigase.org/protocol/archive#query"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"urn:xmpp:archive:auto"}), new Element("feature", new String[]{"var"}, new String[]{"urn:xmpp:archive:manage"})};
    @Inject
    private MessageArchivePlugin messageArchivePlugin;

    public String id() {
        return ID;
    }

    public String[][] supElementNamePaths() {
        return ELEMENT_PATHS;
    }

    public String[] supNamespaces() {
        return XMLNSS;
    }

    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            return;
        }
        try {
            if (this.messageArchivePlugin.getComponentJid().equals((Object)packet.getPacketFrom())) {
                JID connId = session.getConnectionId(packet.getStanzaTo());
                Packet result = packet.copyElementOnly();
                result.setPacketTo(connId);
                results.offer(result);
                return;
            }
            if (packet.getType() != StanzaType.get && packet.getType() != StanzaType.set) {
                return;
            }
            Element auto = packet.getElement().getChild(AUTO);
            Element pref = packet.getElement().getChild("pref");
            if (auto == null && pref == null) {
                Packet result = packet.copyElementOnly();
                if (result.getStanzaFrom() == null) {
                    result.initVars(session.getJID(), this.messageArchivePlugin.getComponentJid());
                }
                result.setPacketTo(this.messageArchivePlugin.getComponentJid());
                results.offer(result);
            } else if (pref != null) {
                if (packet.getType() == StanzaType.get) {
                    this.requestingPreferrences(session, packet, results);
                } else if (packet.getType() == StanzaType.set) {
                    this.updatingPreferences(session, packet, pref, results);
                } else {
                    results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, null, true));
                }
            } else {
                this.updateAutoSave(session, packet, auto, results);
            }
        }
        catch (TigaseDBException ex) {
            log.log(Level.WARNING, "Failed to access database during processing of packet: " + packet.toString(), ex);
            results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Internal server error occurred", false));
        }
        catch (NotAuthorizedException ex) {
            log.log(Level.WARNING, "NotAuthorizedException for packet: {0}", packet);
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
    }

    protected void requestingPreferrences(XMPPResourceConnection session, Packet packet, Queue<Packet> results) throws NotAuthorizedException, TigaseDBException {
        Settings settings = this.messageArchivePlugin.getSettings(session.getBareJID(), session);
        Element prefEl = new Element("pref");
        prefEl.setXMLNS(XEP0136NS);
        Element autoEl = new Element(AUTO);
        autoEl.setAttribute(SAVE, String.valueOf(settings.isAutoArchivingEnabled()));
        prefEl.addChild((XMLNodeIfc)autoEl);
        Element defaultEl = new Element("default");
        defaultEl.setAttribute("otr", "forbid");
        try {
            MessageArchiveVHostItemExtension extension = (MessageArchiveVHostItemExtension)session.getDomain().getExtension(MessageArchiveVHostItemExtension.class);
            RetentionType retentionType = extension == null ? RetentionType.unlimited : extension.getRetentionType();
            String expire = null;
            switch (retentionType) {
                case userDefined: {
                    expire = session.getData(SETTINGS, EXPIRE, null);
                    break;
                }
                case numberOfDays: {
                    Integer retention = extension.getRetentionDays();
                    if (retention == null) break;
                    expire = String.valueOf(retention.longValue() * 60L * 60L * 24L);
                    break;
                }
            }
            if (expire != null) {
                defaultEl.setAttribute(EXPIRE, expire);
            }
        }
        catch (TigaseDBException ex) {
            log.log(Level.WARNING, "could not retrieve expire setting for message archive for user {0}", session.getjid());
        }
        boolean isStoreMuc = StoreMuc.True == StoreMuc.valueof(session.getData(SETTINGS, MUC_SAVE, "false"));
        defaultEl.setAttribute(MUC_SAVE, Boolean.toString(isStoreMuc));
        StoreMethod storeMethod = settings.getStoreMethod();
        defaultEl.setAttribute(SAVE, storeMethod.toString());
        prefEl.addChild((XMLNodeIfc)defaultEl);
        Element methodEl = new Element("method");
        methodEl.setAttribute("type", AUTO);
        methodEl.setAttribute("use", "prefer");
        prefEl.addChild((XMLNodeIfc)methodEl);
        methodEl = new Element("method");
        methodEl.setAttribute("type", "local");
        methodEl.setAttribute("use", "prefer");
        prefEl.addChild((XMLNodeIfc)methodEl);
        methodEl = new Element("method");
        methodEl.setAttribute("type", "manual");
        methodEl.setAttribute("use", "prefer");
        prefEl.addChild((XMLNodeIfc)methodEl);
        results.offer(packet.okResult(prefEl, 0));
    }

    /*
     * Unable to fully structure code
     */
    protected void updatingPreferences(XMPPResourceConnection session, Packet packet, Element pref, Queue<Packet> results) throws PacketErrorTypeException, NotAuthorizedException {
        maExt = Optional.ofNullable((MessageArchiveVHostItemExtension)session.getDomain().getExtension(MessageArchiveVHostItemExtension.class));
        requiredStoreMethod = this.messageArchivePlugin.getRequiredStoreMethod(maExt);
        settings = this.messageArchivePlugin.getSettings(session.getBareJID(), session);
        error = null;
        storeMethod = null;
        autoSave = null;
        errorMsg = null;
        expire = null;
        storeMuc = null;
        block14: for (Element elem : pref.getChildren()) {
            var16_17 = elem.getName();
            var17_18 = -1;
            switch (var16_17.hashCode()) {
                case 1544803905: {
                    if (!var16_17.equals("default")) break;
                    var17_18 = 0;
                    break;
                }
                case 3005871: {
                    if (!var16_17.equals("auto")) break;
                    var17_18 = 1;
                }
            }
            switch (var17_18) {
                case 0: {
                    storeMethodStr = elem.getAttributeStaticStr("save");
                    if (storeMethodStr == null) ** GOTO lbl40
                    try {
                        storeMethod = StoreMethod.valueof(storeMethodStr);
                        if (storeMethod == StoreMethod.Stream) {
                            error = Authorization.FEATURE_NOT_IMPLEMENTED;
                            errorMsg = "Value stream of save attribute is not supported";
                            break;
                        }
                        if (storeMethod.ordinal() < requiredStoreMethod.ordinal()) {
                            error = Authorization.NOT_ACCEPTABLE;
                            errorMsg = "Required minimal message archiving level is " + requiredStoreMethod.toString();
                        }
                        ** GOTO lbl40
                    }
                    catch (IllegalArgumentException ex) {
                        error = Authorization.BAD_REQUEST;
                        errorMsg = "Value " + storeMethodStr + " of save attribute is valid";
                    }
                    break;
lbl40:
                    // 2 sources

                    if ((otr = elem.getAttributeStaticStr("otr")) != null && !"forbid".equals(otr)) {
                        error = Authorization.FEATURE_NOT_IMPLEMENTED;
                        errorMsg = "Value " + otr + " of otr attribute is not supported";
                    }
                    if ((expire = elem.getAttributeStaticStr("expire")) == null) ** GOTO lbl60
                    extension = (MessageArchiveVHostItemExtension)session.getDomain().getExtension(MessageArchiveVHostItemExtension.class);
                    if (extension != null && RetentionType.userDefined == extension.getRetentionType()) ** GOTO lbl49
                    error = Authorization.NOT_ALLOWED;
                    errorMsg = "Expire value is not allowed to be changed by user";
                    ** GOTO lbl60
lbl49:
                    // 1 sources

                    try {
                        val = Long.parseLong(expire);
                        if (val <= 0L) {
                            error = Authorization.NOT_ACCEPTABLE;
                            errorMsg = "Value of expire attribute must be bigger than 0";
                        }
                        ** GOTO lbl60
                    }
                    catch (NumberFormatException ex) {
                        error = Authorization.BAD_REQUEST;
                        errorMsg = "Value of expire attribute must be a number";
                    }
                    break;
lbl60:
                    // 3 sources

                    if ((storeMuc = elem.getAttributeStaticStr("muc-save")) == null) continue block14;
                    if (StoreMuc.User != this.messageArchivePlugin.getRequiredStoreMucMessages(session)) {
                        error = Authorization.NOT_ALLOWED;
                        errorMsg = "Store MUC value is not allowed to be changed by user";
                        break;
                    }
                    if (!"true".equals(storeMuc) && !"false".equals(storeMuc)) {
                        error = Authorization.BAD_REQUEST;
                        errorMsg = "Value of muc-save attribute must be 'true' or 'false'";
                        break;
                    }
                    sm = storeMethod;
                    if (sm != StoreMethod.False) continue block14;
                    error = Authorization.NOT_ACCEPTABLE;
                    errorMsg = "Can not change MUC message storage configuration as Message Archiving is disabled";
                    break;
                }
                case 1: {
                    autoSave = Boolean.valueOf(elem.getAttributeStaticStr("save"));
                    if (!(requiredStoreMethod == StoreMethod.False || autoSave != null && autoSave.booleanValue())) {
                        error = Authorization.NOT_ACCEPTABLE;
                        errorMsg = "Required minimal message archiving level is " + requiredStoreMethod.toString() + " and that requires automatic archiving to be enabled";
                    }
                    extension = (MessageArchiveVHostItemExtension)session.getDomain().getExtension(MessageArchiveVHostItemExtension.class);
                    if (!autoSave.booleanValue() || extension != null && extension.isEnabled()) continue block14;
                    error = Authorization.NOT_ALLOWED;
                    errorMsg = "Message archiving is not allowed for domain " + session.getDomainAsJID().toString();
                    break;
                }
                default: {
                    error = Authorization.FEATURE_NOT_IMPLEMENTED;
                    errorMsg = null;
                }
            }
        }
        if (error != null) {
            results.offer(error.getResponseMessage(packet, errorMsg, true));
        } else {
            try {
                if (autoSave != null) {
                    settings.setAuto(autoSave);
                }
                if (storeMethod != null) {
                    settings.setStoreMethod(storeMethod);
                }
                if (expire != null) {
                    session.setData("message-archive/settings", "expire", expire);
                }
                if (storeMuc != null) {
                    settings.setArchiveMucMessages(Boolean.parseBoolean(storeMuc));
                }
                settings.setArchiveOnlyForContactsInRoster(false);
                session.setData("message-archive", "settings", settings.serialize());
                results.offer(packet.okResult((String)null, 0));
            }
            catch (TigaseDBException ex) {
                results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, null, false));
            }
        }
    }

    protected void updateAutoSave(XMPPResourceConnection session, Packet packet, Element auto, Queue<Packet> results) throws PacketErrorTypeException, NotAuthorizedException {
        Optional<MessageArchiveVHostItemExtension> maExt = Optional.ofNullable((MessageArchiveVHostItemExtension)session.getDomain().getExtension(MessageArchiveVHostItemExtension.class));
        StoreMethod requiredStoreMethod = this.messageArchivePlugin.getRequiredStoreMethod(maExt);
        String val = auto.getAttributeStaticStr(SAVE);
        if (val == null) {
            val = "";
        }
        boolean save = false;
        switch (val) {
            case "true": 
            case "1": {
                save = true;
                break;
            }
            case "false": 
            case "0": {
                save = false;
                break;
            }
            default: {
                results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Save value is incorrect or missing", false));
                return;
            }
        }
        if (!save && requiredStoreMethod != StoreMethod.False) {
            results.offer(Authorization.NOT_ACCEPTABLE.getResponseMessage(packet, "Required minimal message archiving level is " + requiredStoreMethod.toString() + " and that requires automatic archiving to be enabled", false));
            return;
        }
        MessageArchiveVHostItemExtension extension = (MessageArchiveVHostItemExtension)session.getDomain().getExtension(MessageArchiveVHostItemExtension.class);
        if (save && (extension == null || !extension.isEnabled())) {
            results.offer(Authorization.NOT_ACCEPTABLE.getResponseMessage(packet, "Message archiving is not allowed for domain " + session.getDomainAsJID().toString(), false));
            return;
        }
        try {
            Settings settings = this.messageArchivePlugin.getSettings(session.getBareJID(), session);
            settings.setAuto(save);
            session.setData("message-archive", "settings", settings.serialize());
            Element res = new Element(AUTO);
            res.setXMLNS(XEP0136NS);
            res.setAttribute(SAVE, save ? "true" : "false");
            results.offer(packet.okResult(res, 0));
            return;
        }
        catch (TigaseDBException ex) {
            log.log(Level.WARNING, "Error setting Message Archive state: {0}", ex.getMessage());
            results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database error occured", true));
            return;
        }
    }
}

