/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive;

import tigase.archive.StoreMethod;
import tigase.archive.StoreMuc;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;

public class Settings {
    private static final SimpleParser parser = SingletonFactory.getParserInstance();
    private boolean archiveMucMessages = false;
    private boolean archiveOnlyForContactsInRoster = false;
    private boolean auto = false;
    private StoreMethod storeMethod = StoreMethod.Message;

    public boolean isAutoArchivingEnabled() {
        return this.auto;
    }

    public boolean archiveOnlyForContactsInRoster() {
        return this.archiveOnlyForContactsInRoster;
    }

    public StoreMethod getStoreMethod() {
        return this.storeMethod;
    }

    public void setStoreMethod(StoreMethod storeMethod) {
        this.storeMethod = storeMethod;
        if (storeMethod == StoreMethod.False) {
            this.auto = false;
        }
    }

    public boolean archiveMucMessages() {
        return this.archiveMucMessages;
    }

    public String serialize() {
        Element prefs = new Element("prefs");
        if (this.auto) {
            prefs.setAttribute("auto", "true");
        }
        if (this.storeMethod != null) {
            prefs.setAttribute("method", this.storeMethod.toString());
        }
        if (this.archiveMucMessages) {
            prefs.setAttribute("muc", "true");
        }
        if (this.archiveOnlyForContactsInRoster) {
            prefs.setAttribute("rosterOnly", "true");
        }
        return prefs.toString();
    }

    public void parse(String data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        DomBuilderHandler handler = new DomBuilderHandler();
        char[] ch = data.toCharArray();
        parser.parse((SimpleHandler)handler, ch, 0, ch.length);
        Element pref = (Element)handler.getParsedElements().poll();
        if (pref == null) {
            return;
        }
        String val = pref.getAttributeStaticStr("auto");
        this.auto = val != null ? Boolean.parseBoolean(val) : false;
        val = pref.getAttributeStaticStr("method");
        this.storeMethod = val != null ? StoreMethod.valueof(val) : StoreMethod.Message;
        val = pref.getAttributeStaticStr("muc");
        this.archiveMucMessages = val != null ? Boolean.parseBoolean(val) : false;
        val = pref.getAttributeStaticStr("rosterOnly");
        this.archiveOnlyForContactsInRoster = val != null ? Boolean.parseBoolean(val) : false;
    }

    public void setAuto(boolean auto) {
        this.auto = auto;
        this.archiveOnlyForContactsInRoster = false;
    }

    public void setArchiveMucMessages(boolean archiveMucMessages) {
        this.archiveMucMessages = archiveMucMessages;
    }

    public void setArchiveOnlyForContactsInRoster(boolean archiveOnlyForContactsInRoster) {
        this.archiveOnlyForContactsInRoster = archiveOnlyForContactsInRoster;
    }

    public boolean updateRequirements(StoreMethod requiredStoreMethod, StoreMuc storeMuc) {
        boolean change = false;
        if (this.storeMethod.ordinal() < requiredStoreMethod.ordinal()) {
            this.storeMethod = requiredStoreMethod;
            change = true;
        }
        if (requiredStoreMethod != StoreMethod.False) {
            this.auto = true;
            change = true;
        }
        switch (storeMuc) {
            case True: {
                if (this.archiveMucMessages) break;
                this.archiveMucMessages = true;
                change = true;
                break;
            }
            case False: {
                if (!this.archiveMucMessages) break;
                this.archiveMucMessages = false;
                change = true;
                break;
            }
        }
        return change;
    }
}

