/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.ext.monitor;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.eventbus.EventBus;
import tigase.eventbus.HandleEvent;
import tigase.extras.mailer.Mailer;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.monitor.MonitorComponent;
import tigase.monitor.MonitorExtension;
import tigase.monitor.tasks.TasksEvent;
import tigase.xml.XMLUtils;

@Bean(name="monitor-mailer", active=true, exportable=true)
public class MonitorMailer
implements MonitorExtension,
Initializable,
UnregisterAware {
    private static final String REMOTE_EVENT_INDICATOR = "remote";
    private final Logger log = Logger.getLogger(this.getClass().getName());
    @Inject
    private MonitorComponent component;
    @Inject
    private EventBus eventBus;
    @ConfigField(desc="Email notification sender", alias="from-address")
    private String fromAddress = null;
    @Inject
    private Mailer mailSender;
    @ConfigField(desc="Email notification recipients", alias="to-addresses")
    private String toAddresses;

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void beforeUnregister() {
        this.eventBus.unregisterAll((Object)this);
    }

    public void initialize() {
        this.log.config("Initializing Monitor Mailer");
        this.eventBus.registerAll((Object)this);
    }

    public void setProperties(Map<String, Object> props) {
        this.log.config("Configuring Monitor Mailer");
        try {
            this.fromAddress = this.getRequiredProp(props, "mailer-from-address");
            this.log.log(Level.CONFIG, "Setting fromAddress: {0}", this.fromAddress);
            this.toAddresses = this.getRequiredProp(props, "mailer-to-addresses");
            this.log.log(Level.CONFIG, "Setting toAddresses: {0}", this.toAddresses);
        }
        catch (RuntimeException e) {
            this.log.warning(e.getMessage());
            this.log.warning("Mailer is not started");
            return;
        }
    }

    @HandleEvent(filter=HandleEvent.Type.local)
    protected void onEvent(TasksEvent event) {
        String subject = "Tigase Monitor Notification: " + event.getName();
        StringBuilder sb = new StringBuilder();
        sb.append("Tigase Monitor generated event!\n\n");
        sb.append("Event: ").append(event.getName()).append('\n');
        sb.append("Time: ").append(event.getTimestamp()).append('\n');
        sb.append("Description: ").append(event.getDescription()).append('\n');
        sb.append("hostname: ").append(event.getHostname()).append('\n');
        sb.append("hostname_external: ").append(event.getExternal_hostname()).append('\n');
        sb.append("Additional data: ").append('\n');
        for (Map.Entry entry : event.getAdditionalData().entrySet()) {
            sb.append("    ").append((String)entry.getKey()).append(": ").append(XMLUtils.unescape((String)((String)entry.getValue()))).append('\n');
        }
        this.sendMail(subject, sb.toString());
    }

    private String getRequiredProp(Map<String, Object> props, String name) {
        String result;
        try {
            result = (String)props.get(name);
        }
        catch (Exception e) {
            result = null;
            this.log.warning("Problem on reading property '" + name + "'");
        }
        if (result == null) {
            throw new RuntimeException("Property '" + name + "' is not defined!");
        }
        return result;
    }

    private void sendMail(String messageSubject, String messageText) {
        this.mailSender.sendMail(this.fromAddress, this.toAddresses, messageSubject, messageText);
    }
}

