/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.jmdns.JmDNS;
import javax.jmdns.NetworkTopologyDiscovery;
import javax.jmdns.ServiceInfo;
import tigase.annotations.TigaseDeprecated;
import tigase.conf.ConfigurationException;
import tigase.http.AbstractHttpServer;
import tigase.http.HttpMessageReceiver;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.Kernel;
import tigase.net.SocketType;
import tigase.server.AbstractComponentRegistrator;
import tigase.server.ConnectionManager;
import tigase.server.ServerComponent;
import tigase.server.bosh.BoshConnectionManager;
import tigase.server.websocket.WebSocketClientConnectionManager;
import tigase.server.xmppclient.ClientConnectionManager;
import tigase.server.xmppserver.S2SConnectionManager;
import tigase.sys.ShutdownHook;
import tigase.sys.TigaseRuntime;
import tigase.util.dns.DNSResolverFactory;

@Bean(name="mdns", parent=Kernel.class, active=false)
@TigaseDeprecated(since="2.2.0")
@Deprecated
public class MDnsComponent
extends AbstractComponentRegistrator
implements RegistrarBean,
Initializable,
UnregisterAware,
ShutdownHook {
    private static final Logger log = Logger.getLogger(MDnsComponent.class.getCanonicalName());
    private final ConcurrentHashMap<InetAddress, JmDNSItem> instances = new ConcurrentHashMap();
    private Kernel kernel;
    @ConfigField(desc="Advertised hostname of the server", alias="server-host")
    private String serverHost;
    @ConfigField(desc="Advertised server name", alias="server-name")
    private String serverName = "Tigase XMPP Server";
    private Map<String, List<ServiceInfo>> servicesPerComponent = new ConcurrentHashMap<String, List<ServiceInfo>>();
    @ConfigField(desc="Force single server for domain", alias="single-server")
    private boolean singleServer = false;
    @ConfigField(desc="Ignore link-local addresses", alias="ignore-link-local")
    private boolean ignoreLinkLocal = true;
    private Timer timer;

    public MDnsComponent() {
        this.serverHost = DNSResolverFactory.getInstance().getDefaultHost();
        int idx = this.serverHost.indexOf(46);
        if (idx > 0) {
            this.serverHost = this.serverHost.substring(0, idx);
        }
    }

    public String getDiscoCategoryType() {
        return super.getDiscoCategoryType();
    }

    public String getDiscoDescription() {
        return "mDNS component";
    }

    public synchronized void componentAdded(ServerComponent component) throws ConfigurationException {
        if (component instanceof S2SConnectionManager) {
            this.forEachConnection((ConnectionManager)component, (SocketType socketType, Integer port) -> this.addService(component.getName(), "_xmpp-server._tcp.local", (int)port, "S2S"));
        } else if (component instanceof WebSocketClientConnectionManager) {
            this.forEachConnection((ConnectionManager)component, (SocketType socketType, Integer port) -> this.addService(component.getName(), "_xmppconnect.local", "_xmpp-client-websocket=" + (socketType == SocketType.plain ? "ws" : "wss") + "://" + this.serverHost + ":" + port + "/"));
        } else if (component instanceof BoshConnectionManager) {
            this.forEachConnection((ConnectionManager)component, (SocketType socketType, Integer port) -> this.addService(component.getName(), "_xmppconnect", "_xmpp-client-xbosh=" + (socketType == SocketType.plain ? "http" : "https") + "://" + this.serverHost + ":" + port + "/"));
        } else if (component instanceof ClientConnectionManager) {
            this.forEachConnection((ConnectionManager)component, (SocketType socketType, Integer port) -> {
                if (socketType == SocketType.plain) {
                    this.addService(component.getName(), "_xmpp-client._tcp.local", (int)port, "C2S");
                } else {
                    this.addService(component.getName(), "_xmpps-client._tcp.local", (int)port, "C2S over TLS");
                }
            });
        } else if (component instanceof HttpMessageReceiver) {
            this.forEachConnection((HttpMessageReceiver)component, (SocketType socketType, Integer port) -> {
                if (socketType == SocketType.plain) {
                    this.addService(component.getName(), "_http._tcp.local", (int)port, "HTTP Server");
                } else {
                    this.addService(component.getName(), "_https._tcp.local", (int)port, "HTTPS Server");
                }
            });
        }
    }

    public synchronized void componentRemoved(ServerComponent component) {
        this.removeServices(component.getName());
    }

    public boolean isCorrectType(ServerComponent component) {
        return component instanceof ClientConnectionManager || component instanceof S2SConnectionManager || component instanceof HttpMessageReceiver;
    }

    public void register(Kernel kernel) {
        this.kernel = kernel;
    }

    public void unregister(Kernel kernel) {
        this.kernel = null;
    }

    public void initialize() {
        super.initialize();
        if (this.singleServer) {
            this.ensureSingleServer();
        }
        this.timer = new Timer(true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                MDnsComponent.this.updateNetworkTopology();
            }
        }, 1L, 10000L);
        TigaseRuntime.getTigaseRuntime().addShutdownHook((ShutdownHook)this);
    }

    private void updateNetworkTopology() {
        try {
            HashSet<InetAddress> addresses = new HashSet<InetAddress>(Arrays.asList(NetworkTopologyDiscovery.Factory.getInstance().getInetAddresses()));
            addresses.stream().filter(inetAddress -> !this.ignoreLinkLocal || !inetAddress.isLinkLocalAddress()).forEach(addr -> {
                JmDNSItem jmDNS = this.instances.computeIfAbsent((InetAddress)addr, this::createJmDNSItem);
            });
            List toRemove = this.instances.keySet().stream().filter(addr -> !addresses.contains(addr)).collect(Collectors.toList());
            for (InetAddress addr2 : toRemove) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("stopping JmDNS for " + addr2);
                }
                this.stopJmDNS(this.instances.remove(addr2));
            }
        }
        catch (Throwable ex) {
            log.log(Level.SEVERE, "got exception during network topology updated", ex);
        }
    }

    private JmDNSItem createJmDNSItem(InetAddress addr) {
        try {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("starting JmDNS for " + addr);
            }
            JmDNSItem item = new JmDNSItem(addr, this.serverHost);
            this.initializeJmDNS(item);
            return item;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private void stopJmDNS(JmDNSItem jmDNS) {
        if (jmDNS != null) {
            try {
                jmDNS.close();
            }
            catch (IOException ex) {
                log.log(Level.WARNING, "failed to stop mDNS service", ex);
            }
        }
    }

    private void initializeJmDNS(JmDNSItem jmDNSItem) {
        this.servicesPerComponent.values().stream().flatMap(Collection::stream).forEach(info -> jmDNSItem.execute(jmDNS -> {
            try {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("at " + jmDNS.getInetAddress() + " registering " + info.toString());
                }
                jmDNS.registerService(info.clone());
            }
            catch (IOException ex) {
                log.log(Level.WARNING, "Could not advertise mDNS records = " + info.getNiceTextString(), ex);
            }
        }));
    }

    public void beforeUnregister() {
        this.shutdown();
        TigaseRuntime.getTigaseRuntime().removeShutdownHook((ShutdownHook)this);
    }

    public String shutdown() {
        this.timer.cancel();
        this.instances.values().stream().forEach(this::stopJmDNS);
        return null;
    }

    private void addService(String compName, String type, int port, String suffix) {
        ServiceInfo info = ServiceInfo.create((String)type, (String)this.serverHost, (int)port, (String)(this.serverName + " - " + suffix));
        this.addService(compName, info);
    }

    private void addService(String compName, String type, String suffix) {
        ServiceInfo info = ServiceInfo.create((String)type, (String)this.serverHost, (int)0, (String)suffix);
        this.addService(compName, info);
    }

    private void addService(String compName, ServiceInfo info) {
        List services = this.servicesPerComponent.computeIfAbsent(compName, k -> new ArrayList());
        services.add(info);
        this.forEachJmDNS(jmDNS -> {
            try {
                jmDNS.registerService(info.clone());
            }
            catch (IOException ex) {
                log.log(Level.WARNING, "Could not advertise mDNS records = " + info.getNiceTextString(), ex);
            }
        });
    }

    private void removeServices(String compName) {
        List<ServiceInfo> services = this.servicesPerComponent.remove(compName);
        if (services != null) {
            services.forEach(info -> this.forEachJmDNS(jmDNS -> jmDNS.unregisterService(info)));
        }
    }

    private void forEachJmDNS(Consumer<JmDNS> task) {
        this.instances.values().forEach(item -> item.execute(task));
    }

    private void forEachConnection(ConnectionManager component, BiConsumer<SocketType, Integer> consumer) {
        try {
            Kernel compKernel = (Kernel)this.kernel.getInstanceIfExistsOr(component.getName() + "#KERNEL", bc -> null);
            ConnectionManager.PortsConfigBean portsBean = (ConnectionManager.PortsConfigBean)compKernel.getInstanceIfExistsOr("connections", bc -> null);
            Field f = ConnectionManager.PortsConfigBean.class.getDeclaredField("portsBeans");
            f.setAccessible(true);
            ConnectionManager.PortConfigBean[] portBeans = (ConnectionManager.PortConfigBean[])f.get(portsBean);
            if (portBeans != null) {
                for (ConnectionManager.PortConfigBean portConfigBean : portBeans) {
                    Field nameField = ConnectionManager.PortConfigBean.class.getDeclaredField("name");
                    nameField.setAccessible(true);
                    Field socketField = ConnectionManager.PortConfigBean.class.getDeclaredField("socket");
                    socketField.setAccessible(true);
                    consumer.accept((SocketType)socketField.get(portConfigBean), (Integer)nameField.get(portConfigBean));
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Could not retrieve opened ports for component " + component.getName(), ex);
        }
    }

    private void forEachConnection(HttpMessageReceiver component, BiConsumer<SocketType, Integer> consumer) {
        try {
            Kernel compKernel = (Kernel)this.kernel.getInstanceIfExistsOr("httpServer#KERNEL", bc -> null);
            AbstractHttpServer.PortsConfigBean portsBean = (AbstractHttpServer.PortsConfigBean)compKernel.getInstanceIfExistsOr("connections", bc -> null);
            Field f = AbstractHttpServer.PortsConfigBean.class.getDeclaredField("portsBeans");
            f.setAccessible(true);
            AbstractHttpServer.PortConfigBean[] portBeans = (AbstractHttpServer.PortConfigBean[])f.get(portsBean);
            if (portBeans != null) {
                for (AbstractHttpServer.PortConfigBean portConfigBean : portBeans) {
                    consumer.accept(portConfigBean.getSocket(), portConfigBean.getPort());
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Could not retrieve opened ports for component httpServer", ex);
        }
    }

    private void ensureSingleServer() {
        try {
            HashSet<InetAddress> localAddresses = new HashSet<InetAddress>(Arrays.asList(NetworkTopologyDiscovery.Factory.getInstance().getInetAddresses()));
            List<InetAddress> nonlocalAddresses = Arrays.stream(InetAddress.getAllByName(this.serverHost)).filter(address -> !localAddresses.contains(address)).collect(Collectors.toList());
            if (!nonlocalAddresses.isEmpty() && !this.dnsInjectionWorkaround(nonlocalAddresses)) {
                TigaseRuntime.getTigaseRuntime().shutdownTigase(new String[]{"Error! Terminating the server process.", "Local mDNS domain " + this.serverHost + " points to non-local IP addresses:", nonlocalAddresses.stream().map(InetAddress::getHostAddress).collect(Collectors.joining(", "))});
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    private boolean dnsInjectionWorkaround(List<InetAddress> nonlocalAddresses) {
        if (!nonlocalAddresses.stream().anyMatch(InetAddress::isSiteLocalAddress)) {
            try {
                if (Arrays.stream(InetAddress.getAllByName("tig-" + UUID.randomUUID() + "-hub")).anyMatch(nonlocalAddresses::contains)) {
                    log.warning("non-existing domain resolved to the same address as " + this.serverHost + ", disabling forcing single server for domain!!");
                    return true;
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return false;
    }

    private class JmDNSItem
    implements JmDNS.Delegate {
        private final InetAddress address;
        private final String name;
        public JmDNS jmDNS;
        private ExecutorService executor;
        private final LinkedList<Runnable> awaiting = new LinkedList();
        private boolean stopped = false;

        public JmDNSItem(InetAddress address, String name) throws IOException {
            this.address = address;
            this.name = name;
            this.jmDNS = JmDNS.create((InetAddress)address, (String)name);
            this.jmDNS.setDelegate(this::cannotRecoverFromIOError);
            this.executor = Executors.newSingleThreadExecutor();
        }

        public synchronized void execute(Consumer<JmDNS> task) {
            Runnable run = () -> this.executeTask(task);
            try {
                this.executor.execute(run);
            }
            catch (RejectedExecutionException ex) {
                this.awaiting.offer(run);
            }
        }

        public synchronized void close() throws IOException {
            this.stopped = true;
            this.jmDNS.setDelegate(null);
            this.executor.shutdownNow();
            this.jmDNS.close();
        }

        public synchronized void cannotRecoverFromIOError(JmDNS jmDNS, final Collection<ServiceInfo> serviceInfos) {
            jmDNS.setDelegate(null);
            try {
                jmDNS.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.stopped) {
                return;
            }
            final List<Runnable> cancelled = this.executor.shutdownNow();
            MDnsComponent.this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    JmDNSItem.this.restartJmDNS(cancelled, serviceInfos);
                }
            }, 10000L);
        }

        private synchronized void restartJmDNS(final List<Runnable> cancelled, final Collection<ServiceInfo> serviceInfos) {
            try {
                this.jmDNS.setDelegate(null);
                if (this.stopped) {
                    return;
                }
                try {
                    this.jmDNS = JmDNS.create((InetAddress)this.address, (String)this.name);
                    this.jmDNS.setDelegate((JmDNS.Delegate)this);
                    serviceInfos.forEach(info -> {
                        try {
                            this.jmDNS.registerService(info.clone());
                        }
                        catch (IOException ex) {
                            log.log(Level.WARNING, "Could not advertise mDNS records = " + info.getNiceTextString(), ex);
                        }
                    });
                    this.executor = Executors.newSingleThreadExecutor();
                    cancelled.forEach(this.executor::submit);
                    Runnable task = null;
                    while ((task = this.awaiting.poll()) != null) {
                        this.executor.submit(task);
                    }
                }
                catch (IOException ex) {
                    this.jmDNS.close();
                    MDnsComponent.this.timer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            JmDNSItem.this.restartJmDNS(cancelled, serviceInfos);
                        }
                    }, 10000L);
                }
            }
            catch (Throwable ex) {
                log.log(Level.SEVERE, "failed to restart JmDNS", ex);
            }
        }

        private void executeTask(Consumer<JmDNS> task) {
            task.accept(this.jmDNS);
        }
    }
}

