/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules.selfping;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.muc.modules.selfping.SelfPingerMonitor;
import tigase.xmpp.jid.JID;

public class Request {
    private static final Logger log = Logger.getLogger(Request.class.getName());
    private final String id;
    private final JID jid;
    private final JID jidTo;
    private final SelfPingerMonitor monitor;
    private final Map<String, JID> subrequests = new ConcurrentHashMap<String, JID>();
    private final long timestampt = System.currentTimeMillis();
    private long requestsCounter = 0L;
    private long resultErrorCounter = 0L;
    private long resultOkCounter = 0L;
    private long resultTimeoutCounter = 0L;

    public Request(SelfPingerMonitor monitor, JID jid, JID to, String id) {
        this.monitor = monitor;
        this.jid = jid;
        this.jidTo = to;
        this.id = id;
    }

    public JID getJidTo() {
        return this.jidTo;
    }

    public long getResultErrorCounter() {
        return this.resultErrorCounter;
    }

    public long getResultOkCounter() {
        return this.resultOkCounter;
    }

    public long getNoResultCounter() {
        return this.subrequests.size();
    }

    public String getId() {
        return this.id;
    }

    public JID getJid() {
        return this.jid;
    }

    public long getTimestampt() {
        return this.timestampt;
    }

    public void registerRequest(JID jid, String stanzaId) {
        String key = SelfPingerMonitor.key(jid, stanzaId);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Registering request, jid: {0}, stanzaId: {1}, key: {2}, subrequests: {3}", new Object[]{jid, stanzaId, key, this.subrequests});
        }
        this.subrequests.put(key, jid);
        this.monitor.registerSubRequest(key, this);
        ++this.requestsCounter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Request)) {
            return false;
        }
        Request request = (Request)o;
        if (!this.id.equals(request.id)) {
            return false;
        }
        return this.jid.equals((Object)request.jid);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.jid.hashCode();
        return result;
    }

    public Collection<JID> getTimeoutedJIDs() {
        return Collections.unmodifiableCollection(this.subrequests.values());
    }

    public void registerResponse(JID jid, String stanzaId, Result result) {
        String key = SelfPingerMonitor.key(jid, stanzaId);
        boolean containsKey = this.subrequests.containsKey(key);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Registering response ping, jid: {0}, stanzaId: {1}, result: {2}, containsKey: {3}, subrequests: {4}", new Object[]{jid, stanzaId, result, containsKey, this.subrequests.size()});
        }
        if (containsKey) {
            switch (result) {
                case Ok: {
                    ++this.resultOkCounter;
                    this.subrequests.remove(key);
                    break;
                }
                case Error: {
                    ++this.resultErrorCounter;
                    this.subrequests.remove(key);
                    this.monitor.kickOut(jid);
                    break;
                }
                case Timeout: {
                    ++this.resultTimeoutCounter;
                    this.monitor.kickOut(jid);
                }
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Registering response ping[2], jid: {0}, stanzaId: {1}, result: {2}, subrequests: {3}, this.Request: {4}", new Object[]{jid, stanzaId, result, this.subrequests.size(), this});
        }
        if (this.subrequests.isEmpty() || this.resultOkCounter + this.resultErrorCounter + this.resultTimeoutCounter == this.requestsCounter) {
            this.monitor.finish(this);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Request{");
        sb.append("id='").append(this.id).append('\'');
        sb.append(", jid=").append(this.jid);
        sb.append(", jidTo=").append(this.jidTo);
        sb.append(", timestampt=").append(this.timestampt);
        sb.append(", requestsCounter=").append(this.requestsCounter);
        sb.append(", resultErrorCounter=").append(this.resultErrorCounter);
        sb.append(", resultOkCounter=").append(this.resultOkCounter);
        sb.append(", resultTimeoutCounter=").append(this.resultTimeoutCounter);
        sb.append(", timeoutedJIDs=").append(this.getTimeoutedJIDs());
        sb.append('}');
        return sb.toString();
    }

    public static enum Result {
        Ok,
        Error,
        Timeout;

    }
}

