/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import tigase.component.modules.Module;
import tigase.muc.Affiliation;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.StatusCodes;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public interface PresenceModule
extends Module {
    public static final String ID = "presences";

    public void doQuit(Room var1, JID var2, Integer ... var3) throws TigaseStringprepException;

    public void sendPresencesToNewOccupant(Room var1, JID var2) throws TigaseStringprepException;

    public static class PresenceWrapper {
        final Element[] items;
        final Packet packet;
        final Element x;

        public static PresenceWrapper preparePresenceW(Room room, JID destinationJID, Element presence, BareJID occupantBareJID, Collection<JID> occupantJIDs, String occupantNickname, Affiliation occupantAffiliation, Role occupantRole) throws TigaseStringprepException {
            RoomConfig.WhoisPrivilege whois = room.getConfig().getWhois();
            Affiliation destinationAffiliation = room.getAffiliation(destinationJID.getBareJID()).getAffiliation();
            try {
                presence.setAttribute("from", JID.jidInstance((BareJID)room.getRoomJID(), (String)occupantNickname).toString());
            }
            catch (TigaseStringprepException e) {
                presence.setAttribute("from", room.getRoomJID() + "/" + occupantNickname);
            }
            presence.setAttribute("to", destinationJID.toString());
            Element x = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
            ArrayList<Element> items = new ArrayList<Element>();
            if (whois == RoomConfig.WhoisPrivilege.anyone || whois == RoomConfig.WhoisPrivilege.moderators && destinationAffiliation.isViewOccupantsJid()) {
                for (JID jid : occupantJIDs) {
                    Element item = new Element("item", new String[]{"affiliation", "role", "nick", "jid"}, new String[]{occupantAffiliation.name(), occupantRole.name(), occupantNickname, jid.toString()});
                    x.addChild((XMLNodeIfc)item);
                    items.add(item);
                }
            } else {
                Element item = new Element("item", new String[]{"affiliation", "role", "nick"}, new String[]{occupantAffiliation.name(), occupantRole.name(), occupantNickname});
                x.addChild((XMLNodeIfc)item);
                items.add(item);
            }
            presence.addChild((XMLNodeIfc)x);
            Packet packet = Packet.packetInstance((Element)presence);
            packet.setXMLNS("jabber:client");
            PresenceWrapper wrapper = new PresenceWrapper(packet, x, items.toArray(new Element[0]));
            if (occupantBareJID != null && occupantBareJID.equals((Object)destinationJID.getBareJID())) {
                wrapper.packet.setPriority(Priority.HIGH);
                wrapper.addStatusCode(StatusCodes.SELF_PRESENCE);
                if (whois == RoomConfig.WhoisPrivilege.anyone) {
                    wrapper.addStatusCode(StatusCodes.OCCUPANT_IS_ALLOWED_TO_SEE_JID);
                }
                if (room.getConfig().isLoggingEnabled()) {
                    wrapper.addStatusCode(StatusCodes.ROOM_LOGGING_IS_ENABLED);
                }
            }
            return wrapper;
        }

        static PresenceWrapper preparePresenceW(Room room, JID destinationJID, Element presence, BareJID occupantJID, String occupantNickname, Affiliation occupantAffiliation, Role occupantRole) throws TigaseStringprepException {
            Collection<JID> occupantJIDs = room.getOccupantsJidsByNickname(occupantNickname);
            return PresenceWrapper.preparePresenceW(room, destinationJID, presence, occupantJID, occupantJIDs, occupantNickname, occupantAffiliation, occupantRole);
        }

        static PresenceWrapper preparePresenceW(Room room, JID destinationJID, Element presence, JID occupantJID) throws TigaseStringprepException {
            String occupantNickname = room.getOccupantsNickname(occupantJID);
            if (occupantNickname == null) {
                Affiliation occupantAffiliation = room.getAffiliation(occupantJID.getBareJID()).getAffiliation();
                return PresenceWrapper.preparePresenceW(room, destinationJID, presence, occupantJID.getBareJID(), Collections.singleton(occupantJID), occupantJID.getBareJID().toString(), occupantAffiliation, Role.none);
            }
            return PresenceWrapper.preparePresenceW(room, destinationJID, presence, occupantNickname);
        }

        static PresenceWrapper preparePresenceW(Room room, JID destinationJID, Element presence, String occupantNickname) throws TigaseStringprepException {
            BareJID occupantJID = room.getOccupantsJidByNickname(occupantNickname);
            Affiliation occupantAffiliation = room.getAffiliation(occupantJID).getAffiliation();
            Role occupantRole = room.getRole(occupantNickname);
            return PresenceWrapper.preparePresenceW(room, destinationJID, presence, occupantJID, occupantNickname, occupantAffiliation, occupantRole);
        }

        PresenceWrapper(Packet packet, Element x, Element[] items) {
            this.packet = packet;
            this.x = x;
            this.items = items;
        }

        public Packet getPacket() {
            return this.packet;
        }

        public Element getX() {
            return this.x;
        }

        public void addStatusCode(int code) {
            boolean alreadySet;
            String codeToSet = String.valueOf(code).intern();
            boolean bl = alreadySet = this.x.getChildren(element -> "status" == element.getName() && element.getAttributeStaticStr("code") == codeToSet) != null;
            if (!alreadySet) {
                this.x.addChild((XMLNodeIfc)new Element("status", new String[]{"code"}, new String[]{codeToSet}));
            }
        }
    }
}

