/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.logging.Level;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.muc.MUCConfig;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractMucModule;
import tigase.muc.repository.IMucRepository;
import tigase.server.Packet;
import tigase.util.Base64;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="iqforwarder", active=true)
public class IqStanzaForwarderModule
extends AbstractMucModule {
    public static final String ID = "iqforwarder";
    private static final Criteria SELF_PING_CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"ping", (String)"urn:xmpp:ping"));
    @Inject
    private MUCConfig config;
    @Inject
    private IMucRepository repository;
    private final Criteria crit = new Criteria(){

        public Criteria add(Criteria criteria) {
            return null;
        }

        public boolean match(Element element) {
            return IqStanzaForwarderModule.this.checkIfProcessed(element);
        }
    };

    public String[] getFeatures() {
        return null;
    }

    public Criteria getModuleCriteria() {
        return this.crit;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        try {
            boolean isRequest = this.isRequest(packet);
            JID senderJID = packet.getStanzaFrom();
            BareJID roomJID = packet.getStanzaTo().getBareJID();
            String recipientNickname = IqStanzaForwarderModule.getNicknameFromJid(packet.getStanzaTo());
            if (recipientNickname == null) {
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            Room room = this.repository.getRoom(roomJID);
            if (room == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND);
            }
            String senderNickname = Optional.ofNullable(room.getOccupantsNickname(senderJID)).or(() -> !isRequest ? room.getOccupantsNicknames(senderJID.getBareJID()).stream().findFirst() : Optional.empty()).orElseThrow(() -> new MUCException(Authorization.NOT_ACCEPTABLE, IqStanzaForwarderModule.getNicknameFromJid(senderJID) + " is not in room"));
            Role senderRole = room.getRole(senderNickname);
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "Processing IQ stanza, from: {0}, to: {1}, recipientNickname: {2}, senderNickname: {3}, senderRole: {4} ", new Object[]{senderJID, roomJID, recipientNickname, senderNickname, senderRole});
            }
            if (!senderRole.isSendPrivateMessages()) {
                throw new MUCException(Authorization.NOT_ALLOWED, "Role is not allowed to send private messages");
            }
            this.forwardPacket(packet, room, senderNickname, senderJID, recipientNickname, isRequest);
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (TigaseStringprepException e) {
            throw new MUCException(Authorization.BAD_REQUEST);
        }
        catch (Exception e) {
            this.log.log(Level.FINEST, "Error during forwarding IQ", e);
            throw new RuntimeException(e);
        }
    }

    protected boolean isRequest(Packet packet) throws MUCException {
        StanzaType type = packet.getType();
        if (type == null) {
            throw new MUCException(Authorization.BAD_REQUEST, "IQ stanza is required to have a type");
        }
        switch (type) {
            case result: 
            case error: {
                return false;
            }
            case set: 
            case get: {
                return true;
            }
        }
        throw new MUCException(Authorization.BAD_REQUEST, "IQ stanza has invalid type");
    }

    protected static String generateJidShortcut(JID jid) throws ComponentException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] arr = md.digest(jid.toString().getBytes(StandardCharsets.UTF_8));
            return Base64.encode((byte[])Arrays.copyOfRange(arr, arr.length - 6, arr.length));
        }
        catch (NoSuchAlgorithmException e) {
            throw new ComponentException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    protected void forwardPacket(Packet packet, Room room, String senderNickname, JID senderJID, String recipientNickname, boolean isRequest) throws ComponentException, TigaseStringprepException {
        if (this.config.isMultiItemModeForwardBest()) {
            String id = packet.getStanzaId();
            if (id == null) {
                throw new MUCException(Authorization.BAD_REQUEST, "IQ stanza is required to have id attribute");
            }
            if (isRequest) {
                JID recipientJid2 = room.getOccupantJidForIqRequestForward(recipientNickname).orElseThrow(() -> new MUCException(Authorization.ITEM_NOT_FOUND, "Unknown recipient"));
                if (packet.getElemChild("vCard", "vcard-temp") != null) {
                    recipientJid2 = recipientJid2.copyWithoutResource();
                }
                String idPrefix = IqStanzaForwarderModule.generateJidShortcut(senderJID);
                this.forwardPacket(packet, room.getRoomJID(), senderNickname, recipientJid2, idPrefix + "-" + id);
            } else if (id.length() >= 8) {
                String idPrefix = id.substring(0, 8);
                room.getOccupantJidForIqResponseForward(recipientNickname, jid -> {
                    try {
                        return idPrefix.equals(IqStanzaForwarderModule.generateJidShortcut(jid));
                    }
                    catch (ComponentException ex) {
                        return false;
                    }
                }).ifPresent(recipientJid -> {
                    try {
                        this.forwardPacket(packet, room.getRoomJID(), senderNickname, (JID)recipientJid, id.substring(9));
                    }
                    catch (TigaseStringprepException ex) {
                        this.log.log(Level.FINEST, "Could not forward response to request sender", ex);
                    }
                });
            } else if (!id.startsWith("spng-")) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND, "Unknown recipient");
            }
        } else {
            if (room.getOccupantsJidsByNickname(senderNickname).size() > 1) {
                throw new MUCException(Authorization.NOT_ALLOWED, "Many source resources detected.");
            }
            Collection<JID> recipientJids = room.getOccupantsJidsByNickname(recipientNickname);
            if (recipientJids == null || recipientJids.isEmpty()) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND, "Unknown recipient");
            }
            if (recipientJids.size() > 1) {
                throw new MUCException(Authorization.NOT_ALLOWED, "Many destination resources detected.");
            }
            this.forwardPacket(packet, room.getRoomJID(), senderNickname, recipientJids.iterator().next(), null);
        }
    }

    protected void forwardPacket(Packet packet, BareJID roomJID, String senderNickname, JID recipientJid, String id) throws TigaseStringprepException {
        Element iq = packet.getElement().clone();
        if (id != null) {
            iq.setAttribute("id", id);
        }
        Packet p = Packet.packetInstance((Element)iq, (JID)JID.jidInstance((BareJID)roomJID, (String)senderNickname), (JID)recipientJid);
        p.setXMLNS("jabber:client");
        this.write(p);
    }

    protected boolean checkIfProcessed(Element element) {
        if (element.getName() != "iq") {
            return false;
        }
        try {
            String recipientNickname = IqStanzaForwarderModule.getNicknameFromJid(JID.jidInstance((String)element.getAttributeStaticStr("to")));
            if (recipientNickname == null) {
                return false;
            }
            JID senderJID = JID.jidInstance((String)element.getAttributeStaticStr("from"));
            BareJID roomJID = BareJID.bareJIDInstance((String)element.getAttributeStaticStr("to"));
            Room room = this.repository.getRoom(roomJID);
            if (room == null) {
                return false;
            }
            String senderNickname = room.getOccupantsNickname(senderJID);
            if (this.isSelfPing(element)) {
                return !recipientNickname.equals(senderNickname);
            }
            return true;
        }
        catch (TigaseStringprepException e) {
            return false;
        }
        catch (RepositoryException e) {
            return false;
        }
        catch (MUCException e) {
            return false;
        }
    }

    private boolean isSelfPing(Element element) {
        return SELF_PING_CRIT.match(element);
    }
}

