/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.history;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DataRepository;
import tigase.muc.Room;
import tigase.muc.history.AbstractJDBCHistoryProvider;
import tigase.xml.Element;
import tigase.xmpp.jid.JID;

public class PostgreSqlHistoryProvider
extends AbstractJDBCHistoryProvider {
    public static final String ADD_MESSAGE_QUERY_VAL = "insert into muc_history (room_name, event_type, timestamp, sender_jid, sender_nickname, body, public_event, msg) values (?, 1, ?, ?, ?, ?, ?, ?)";
    public static final String DELETE_MESSAGES_QUERY_VAL = "delete from muc_history where room_name=?";
    public static final String GET_MESSAGES_MAXSTANZAS_QUERY_VAL = "select room_name, event_type, timestamp, sender_jid, sender_nickname, body, msg from (select * from muc_history where room_name=? order by timestamp desc limit ? ) AS t order by t.timestamp";
    public static final String GET_MESSAGES_SINCE_QUERY_VAL = "select room_name, event_type, timestamp, sender_jid, sender_nickname, body, msg from (select * from muc_history where room_name=? and timestamp >= ? order by timestamp desc limit ? ) AS t order by t.timestamp";
    private static final String CREATE_MUC_HISTORY_TABLE_VAL = "create table muc_history (room_name char(128) NOT NULL,\nevent_type int, \ntimestamp bigint,\nsender_jid varchar(2049),\nsender_nickname char(128),\nbody text,\npublic_event boolean,\n msg text )";
    private Logger log = Logger.getLogger(this.getClass().getName());

    @Override
    public void addJoinEvent(Room room, Date date, JID senderJID, String nickName) {
    }

    @Override
    public void addLeaveEvent(Room room, Date date, JID senderJID, String nickName) {
    }

    @Override
    public void addSubjectChange(Room room, Element message, String subject, JID senderJid, String senderNickname, Date time) {
    }

    public void init(DataRepository dataRepository) {
        try {
            dataRepository.checkTable("muc_history", CREATE_MUC_HISTORY_TABLE_VAL);
            this.internalInit(dataRepository);
        }
        catch (SQLException e) {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.log(Level.WARNING, "Initializing problem", e);
            }
            try {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Trying to create tables: create table muc_history (room_name char(128) NOT NULL,\nevent_type int, \ntimestamp bigint,\nsender_jid varchar(2049),\nsender_nickname char(128),\nbody text,\npublic_event boolean,\n msg text )");
                }
                Statement st = dataRepository.createStatement(null);
                st.execute(CREATE_MUC_HISTORY_TABLE_VAL);
                this.internalInit(dataRepository);
            }
            catch (SQLException e1) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.log(Level.WARNING, "Can't initialize muc history", e1);
                }
                throw new RuntimeException(e1);
            }
        }
    }

    @Override
    public void setDataSource(DataRepository dataSource) {
        this.init(dataSource);
        super.setDataSource(dataSource);
    }

    private void internalInit(DataRepository dataRepository) throws SQLException {
        dataRepository.initPreparedStatement("ADD_MESSAGE_QUERY_KEY", ADD_MESSAGE_QUERY_VAL);
        dataRepository.initPreparedStatement("DELETE_MESSAGES_QUERY_KEY", DELETE_MESSAGES_QUERY_VAL);
        dataRepository.initPreparedStatement("GET_MESSAGES_SINCE_QUERY_KEY", GET_MESSAGES_SINCE_QUERY_VAL);
        dataRepository.initPreparedStatement("GET_MESSAGES_MAXSTANZAS_QUERY_KEY", GET_MESSAGES_MAXSTANZAS_QUERY_VAL);
    }
}

