/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.muc.Affiliation;
import tigase.muc.Room;
import tigase.muc.RoomAffiliation;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class PresenceFiltered
implements Room.RoomOccupantListener,
Room.RoomListener {
    protected static final Logger log = Logger.getLogger(PresenceFiltered.class.getName());
    private final Collection<BareJID> occupantsPresenceFiltered = new ConcurrentSkipListSet<BareJID>();
    private final Room room;

    public PresenceFiltered(Room room) {
        this.room = room;
    }

    public Collection<BareJID> getOccupantsPresenceFiltered() {
        return this.occupantsPresenceFiltered;
    }

    public Collection<JID> getOccupantsPresenceFilteredJIDs() {
        ConcurrentSkipListSet<JID> occupantsJIDs = new ConcurrentSkipListSet<JID>();
        for (BareJID jid : this.occupantsPresenceFiltered) {
            for (String occupantsNickname : this.room.getOccupantsNicknames(jid)) {
                for (JID occuJID : this.room.getOccupantsJidsByNickname(occupantsNickname)) {
                    occupantsJIDs.add(occuJID);
                }
            }
        }
        return occupantsJIDs;
    }

    public Collection<String> getOccupantsPresenceFilteredNicknames() {
        ConcurrentSkipListSet<String> occupantsNicknames = new ConcurrentSkipListSet<String>();
        for (BareJID jid : this.occupantsPresenceFiltered) {
            for (String occupantsNickname : this.room.getOccupantsNicknames(jid)) {
                occupantsNicknames.add(occupantsNickname);
            }
        }
        return occupantsNicknames;
    }

    @Override
    public void onChangeSubject(Room room, String nick, String newSubject, Date changeDate) {
    }

    @Override
    public void onMessageToOccupants(Room room, JID from, Packet msg) {
    }

    @Override
    public void onOccupantAdded(Room room, JID occupantJid) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Adding: " + occupantJid + " to occupantsPresenceFiltered: " + Arrays.asList(this.occupantsPresenceFiltered));
        }
        this.occupantsPresenceFiltered.add(occupantJid.getBareJID());
    }

    @Override
    public void onOccupantChangedPresence(Room room, JID occupantJid, String nickname, Element presence, boolean newOccupant) {
    }

    @Override
    public void onOccupantRemoved(Room room, JID occupantJid) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Removing: " + occupantJid + " to occupantsPresenceFiltered: " + Arrays.asList(this.occupantsPresenceFiltered));
        }
        this.occupantsPresenceFiltered.remove(occupantJid.getBareJID());
    }

    @Override
    public void onSetAffiliation(Room room, BareJID jid, RoomAffiliation oldAffiliation, RoomAffiliation newAffiliation) {
        Collection<Affiliation> presenceFilterFrom;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Modifying affiliation of: " + jid + " on occupantsPresenceFiltered: " + Arrays.asList(this.occupantsPresenceFiltered));
        }
        if ((presenceFilterFrom = room.getConfig().getPresenceFilteredAffiliations()).contains((Object)room.getAffiliation(jid).getAffiliation())) {
            this.occupantsPresenceFiltered.add(jid);
        } else {
            this.occupantsPresenceFiltered.remove(jid);
        }
    }
}

