/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.ScheduledTask;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.muc.MUCComponent;
import tigase.muc.MUCConfig;
import tigase.muc.Room;
import tigase.muc.StatusCodes;
import tigase.muc.modules.PresenceModule;
import tigase.muc.repository.IMucRepository;
import tigase.server.Packet;
import tigase.server.ReceiverTimeoutHandler;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="ghostbuster", parent=MUCComponent.class, active=true)
public class Ghostbuster2
extends ScheduledTask {
    private static final Set<String> intReasons = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("gone");
            this.add("item-not-found");
            this.add("policy-violation");
            this.add("recipient-unavailable");
            this.add("redirect");
            this.add("remote-server-not-found");
            this.add("remote-server-timeout");
            this.add("service-unavailable");
        }
    };
    public static final Set<String> R = Collections.unmodifiableSet(intReasons);
    private static long idCounter;
    protected final Map<JID, MonitoredObject> monitoredObjects = new ConcurrentHashMap<JID, MonitoredObject>();
    private final ReceiverTimeoutHandler pingHandler;
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    @Inject
    private MUCConfig config;
    @Inject
    private MUCComponent mucComponent;
    @Inject
    private PresenceModule presenceModule;
    @Inject
    private IMucRepository repository;

    public Ghostbuster2() {
        super(Duration.ofMinutes(10L), Duration.ofMinutes(5L));
        this.pingHandler = new ReceiverTimeoutHandler(){

            public void responseReceived(Packet data, Packet response) {
                block3: {
                    try {
                        if (Ghostbuster2.this.log.isLoggable(Level.FINEST)) {
                            Ghostbuster2.this.log.log(Level.FINEST, "Received ping response for ping, data: {0}, response: {1}", new Object[]{data, response});
                        }
                        Ghostbuster2.this.onPingReceived(response);
                    }
                    catch (Exception e) {
                        if (!Ghostbuster2.this.log.isLoggable(Level.WARNING)) break block3;
                        Ghostbuster2.this.log.log(Level.WARNING, "Problem on handling ping response", e);
                    }
                }
            }

            public void timeOutExpired(Packet data) {
                block3: {
                    try {
                        if (Ghostbuster2.this.log.isLoggable(Level.FINEST)) {
                            Ghostbuster2.this.log.finest("Received ping timeout for ping " + data.getElement().getAttributeStaticStr("id"));
                        }
                        Ghostbuster2.this.onPingTimeout(data.getStanzaTo());
                    }
                    catch (Exception e) {
                        if (!Ghostbuster2.this.log.isLoggable(Level.WARNING)) break block3;
                        Ghostbuster2.this.log.log(Level.WARNING, "Problem on handling ping timeout", e);
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(JID occupantJid, Room room) {
        try {
            MonitoredObject o = this.monitoredObjects.get(occupantJid);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(occupantJid + " registered in room " + room.getRoomJID());
            }
            if (o == null) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Start observing " + occupantJid);
                }
                o = new MonitoredObject(occupantJid);
                o.lastActivity = System.currentTimeMillis();
                this.monitoredObjects.put(occupantJid, o);
            }
            HashSet<BareJID> hashSet = o.rooms;
            synchronized (hashSet) {
                o.rooms.add(room.getRoomJID());
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Problem on registering occupant", e);
        }
    }

    public PresenceModule getPresenceModule() {
        return this.presenceModule;
    }

    public void setPresenceModule(PresenceModule presenceModule) {
        this.presenceModule = presenceModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping() throws TigaseStringprepException {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Pinging up to 1000 known JIDs with 1h of inactivity");
        }
        int c = 0;
        long now = System.currentTimeMillis();
        long border = now - 3600000L;
        Iterator<MonitoredObject> it = this.monitoredObjects.values().iterator();
        while (it.hasNext() && c < 1000) {
            MonitoredObject entry = it.next();
            if (entry.lastActivity >= border) continue;
            ++c;
            BareJID r = null;
            HashSet<BareJID> hashSet = entry.rooms;
            synchronized (hashSet) {
                if (!entry.rooms.isEmpty()) {
                    r = entry.rooms.iterator().next();
                }
            }
            if (r == null) continue;
            this.ping(r, entry.source);
        }
    }

    public void remove(Collection<JID> occupantJids, Room room) {
        for (JID jid : occupantJids) {
            this.remove(jid, room);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(JID occupantJid, Room room) {
        try {
            MonitoredObject o = this.monitoredObjects.get(occupantJid);
            if (o == null) {
                return;
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(occupantJid + " unregisterd from room " + room.getRoomJID());
            }
            HashSet<BareJID> hashSet = o.rooms;
            synchronized (hashSet) {
                o.rooms.remove(room.getRoomJID());
                if (o.rooms.isEmpty()) {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Stop observing " + occupantJid);
                    }
                    this.monitoredObjects.remove(occupantJid);
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Problem on unregistering occupant", e);
        }
    }

    public void run() {
        if (this.config.isGhostbusterEnabled()) {
            try {
                this.ping();
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "Problem on executing ghostbuster", e);
            }
        }
    }

    public void update(Packet packet) throws TigaseStringprepException {
        if (packet.getStanzaFrom() == null) {
            return;
        }
        MonitoredObject o = this.monitoredObjects.get(packet.getStanzaFrom());
        if (o == null) {
            return;
        }
        if (this.checkError(packet) != null) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Received presence error: " + packet.getElement().toString());
            }
            this.processError(o, packet);
        } else {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Update activity of " + o.source);
            }
            o.lastActivity = System.currentTimeMillis();
        }
    }

    public void kickJIDFromRooms(JID jid, Collection<BareJID> rooms) throws TigaseStringprepException {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "Kicking out JID: {0}, from rooms: {1}", new Object[]{jid, rooms});
        }
        this.monitoredObjects.remove(jid);
        for (Room r : this.repository.getActiveRooms().values()) {
            if (rooms != null && !rooms.contains(r.getRoomJID()) || !r.isOccupantInRoom(jid)) continue;
            this.presenceModule.doQuit(r, jid, StatusCodes.REMOVED_FROM_ROOM);
        }
    }

    protected void onPingReceived(Packet packet) throws TigaseStringprepException {
        this.update(packet);
    }

    protected void onPingTimeout(JID stanzaTo) throws TigaseStringprepException {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Timeouted ping to: " + stanzaTo);
        }
    }

    private String checkError(Packet packet) {
        String type = packet.getElement().getAttributeStaticStr("type");
        if (type == null || !type.equals("error")) {
            return null;
        }
        Element errorElement = packet.getElement().getChild("error");
        if (errorElement == null) {
            return null;
        }
        for (Element reason : errorElement.getChildren()) {
            if (reason.getXMLNS() == null || !reason.getXMLNS().equals("urn:ietf:params:xml:ns:xmpp-stanzas") || !R.contains(reason.getName())) continue;
            return reason.getName();
        }
        return null;
    }

    private void ping(BareJID room, JID occupantJID) throws TigaseStringprepException {
        String id = "png-" + ++idCounter;
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(Level.FINER, "Pinging " + occupantJID + ". id=" + id);
        }
        Element ping = new Element("iq", new String[]{"type", "id", "from", "to"}, new String[]{"get", id, room.toString(), occupantJID.toString()});
        ping.addChild((XMLNodeIfc)new Element("ping", new String[]{"xmlns"}, new String[]{"urn:xmpp:ping"}));
        Packet packet = Packet.packetInstance((Element)ping);
        packet.setXMLNS("jabber:client");
        this.mucComponent.addOutPacketWithTimeout(packet, this.pingHandler, 1L, TimeUnit.MINUTES);
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(Level.FINER, "Pinged " + occupantJID);
        }
    }

    private void processError(MonitoredObject obj, Packet packet) throws TigaseStringprepException {
        if (this.presenceModule == null || this.repository == null) {
            return;
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Forced removal last activity of " + obj.source);
        }
        this.kickJIDFromRooms(obj.source, obj.rooms);
    }

    protected class MonitoredObject {
        private final JID source;
        private long lastActivity;
        private HashSet<BareJID> rooms = new HashSet();

        public MonitoredObject(JID occupantJid) {
            this.source = occupantJid;
        }
    }
}

