--
-- Tigase Workgroup Queues Component - Component for Tigase. Implementation of XEP-0142
-- Copyright (C) 2016 Tigase, Inc. (office@tigase.com) - All Rights Reserved
-- Unauthorized copying of this file, via any medium is strictly prohibited
-- Proprietary and confidential
--

-- QUERY START:
CREATE TABLE IF NOT EXISTS tig_workgroup_queue (
  `jid`           VARCHAR(2049) NOT NULL, /* Workgroup Queue JID */
  `description`   TEXT, /* A description of the queue. */
  `muc_domain`    VARCHAR(2049), /* MUC Component domain name */
  `creation_date` DATETIME      NULL, /* The datetime when the node was created. */
  `creator_jid`   VARCHAR(2049) NOT NULL, /* Creator JID */
  `agents`        MEDIUMTEXT    NULL, /* Comma separated list of agents */
  PRIMARY KEY (`jid`(40)),
  INDEX USING HASH (`jid`(255))
)
  ENGINE = InnoDB
  DEFAULT CHARACTER SET utf8
  ROW_FORMAT = DYNAMIC;
-- QUERY END:

-- QUERY START:
call TigSetComponentVersion('workgroup', '1.0.0');
-- QUERY END:
