/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm;

import com.sun.management.snmp.SnmpEngineId;

public class SnmpUsmEnginePeer {
    SnmpEngineId authoritativeEngineId = null;
    private int authoritativeEngineBoots = 0;
    private int authoritativeEngineTime = 0;
    private long startTime = 0L;
    private int lastReceivedEngineTime = 0;

    SnmpUsmEnginePeer(SnmpEngineId authoritativeEngineId) {
        this.authoritativeEngineId = authoritativeEngineId;
    }

    public SnmpEngineId getAuthoritativeEngineId() {
        return this.authoritativeEngineId;
    }

    public int getAuthoritativeEngineBoots() {
        return this.authoritativeEngineBoots;
    }

    public synchronized int getAuthoritativeEngineTime() {
        if (this.authoritativeEngineTime == 0) {
            return 0;
        }
        long delta = System.currentTimeMillis() / 1000L - this.startTime;
        if (delta > Integer.MAX_VALUE) {
            this.startTime = System.currentTimeMillis() / 1000L;
            if (this.authoritativeEngineBoots != Integer.MAX_VALUE) {
                this.setAuthoritativeEngineBoots(this.authoritativeEngineBoots + 1);
            }
        }
        return this.authoritativeEngineTime + (int)(System.currentTimeMillis() / 1000L - this.startTime);
    }

    public synchronized int getAuthoritativeLastReceivedEngineTime() {
        return this.lastReceivedEngineTime;
    }

    public synchronized void reset() {
        this.setAuthoritativeEngineBoots(0);
        this.setAuthoritativeEngineTime(0);
        this.setAuthoritativeEngineLastReceivedTime(0);
    }

    synchronized void setAuthoritativeEngineBoots(int boots) {
        this.authoritativeEngineBoots = boots;
    }

    synchronized void setAuthoritativeEngineTime(int time) {
        this.startTime = System.currentTimeMillis() / 1000L;
        this.authoritativeEngineTime = time;
    }

    synchronized void setAuthoritativeEngineLastReceivedTime(int time) {
        this.lastReceivedEngineTime = time;
    }
}

