/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpTools;
import com.sun.management.snmp.SnmpPduRequest;
import com.sun.management.snmp.SnmpPduTrap;
import com.sun.management.snmp.SnmpScopedPduRequest;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.agent.SnmpTrapReceiver;
import com.sun.management.snmp.manager.SnmpTrapListener;

class TrapListener
implements SnmpTrapListener {
    private static final String dbgTag = "TrapListener";
    private SnmpTrapReceiver forwarder = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "TrapListener");

    TrapListener(SnmpTrapReceiver forwarder) {
        this.forwarder = forwarder;
    }

    public void processSnmpTrapV1(SnmpPduTrap trap) {
        this.printV1Trap(trap);
        this.forwarder.receivedV1(trap);
    }

    public void processSnmpTrapV2(SnmpPduRequest trap) {
        this.printV2Trap(trap);
        this.forwarder.receivedV2(trap);
    }

    public void processSnmpTrapV3(SnmpScopedPduRequest trap) {
        this.printV3Trap(trap);
        this.forwarder.receivedV3(trap);
    }

    private void printV1Trap(SnmpPduTrap trap) {
        if (logger.finerOn()) {
            logger.finer("printV1Trap", "received V1 trap :");
            logger.finer("printV1Trap", "\tCommunity " + new String(trap.community));
            logger.finer("printV1Trap", "\tEnterprise " + trap.enterprise);
            logger.finer("printV1Trap", "\tGeneric " + trap.genericTrap);
            logger.finer("printV1Trap", "\tSpecific " + trap.specificTrap);
            logger.finer("printV1Trap", "\tTimeStamp " + trap.timeStamp);
            logger.finer("printV1Trap", "\tAgent adress " + trap.agentAddr.stringValue());
            for (int i = 0; i < trap.varBindList.length; ++i) {
                logger.finer("printV1Trap", "oid : " + trap.varBindList[i].getOid() + " val : " + trap.varBindList[i].getSnmpValue() + "\n");
            }
            logger.finer("printV1Trap", "************************************************\n");
        }
    }

    private void printV2Trap(SnmpPduRequest pdu) {
        if (logger.finerOn()) {
            logger.finer("printV2Trap", "received V2 trap :");
            logger.finer("printV2Trap", "\tCommunity " + new String(pdu.community));
            SnmpVarBind[] vars = pdu.varBindList;
            for (int i = 0; i < vars.length; ++i) {
                logger.finer("printV2Trap", "OID " + vars[i].getOid());
                logger.finer("printV2Trap", "Value " + vars[i].getSnmpValue());
            }
            logger.finer("printV2Trap", "************************************************\n");
        }
    }

    private void printV3Trap(SnmpScopedPduRequest trap) {
        if (logger.finerOn()) {
            logger.finer("printV3Trap", "received V3 trap :");
            logger.finer("printV3Trap", "\tContextEngineId : " + new String(SnmpTools.binary2ascii(trap.contextEngineId)) + "\n");
            logger.finer("printV3Trap", "\tContextName : " + new String(trap.contextName) + "\n");
            logger.finer("printV3Trap", "\tMsgFlags : " + trap.msgFlags + "\n");
            logger.finer("printV3Trap", "\tMsgMaxSize : " + trap.msgMaxSize + "\n");
            logger.finer("printV3Trap", "\tMsgSecurityModel : " + trap.msgSecurityModel + "\n");
            logger.finer("printV3Trap", "\tAgent list :\n");
            for (int i = 0; i < trap.varBindList.length; ++i) {
                logger.finer("printV3Trap", "oid : " + trap.varBindList[i].getOid() + " val : " + trap.varBindList[i].getSnmpValue() + "\n");
            }
            logger.finer("printV3Trap", "************************************************\n");
        }
    }
}

