/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.jdmk.tasks.DaemonTaskServer;
import com.sun.jdmk.tasks.TaskServer;
import com.sun.management.snmp.JdmkEngineFactory;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpEngineFactory;
import com.sun.management.snmp.SnmpEngineParameters;
import com.sun.management.snmp.SnmpEventReportDispatcher;
import com.sun.management.snmp.SnmpPduRequest;
import com.sun.management.snmp.SnmpPduTrap;
import com.sun.management.snmp.SnmpScopedPduRequest;
import com.sun.management.snmp.agent.SnmpTrap;
import com.sun.management.snmp.agent.TrapListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;

public class SnmpTrapReceiver {
    private static final String dbgTag = "SnmpTrapReceiver";
    private static int count = 0;
    private TrapListener listener = null;
    private SnmpEventReportDispatcher dispatcher = null;
    private SnmpEngine eng = null;
    private boolean started = false;
    private int port = 0;
    private Thread dispatchThread = null;
    private boolean receiveAsGeneric = false;
    private InetAddress address = null;
    private final TaskServer packetTaskServer;
    private final TaskServer callbackTaskServer;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpTrapReceiver");

    public SnmpTrapReceiver(SnmpEngine engine, int port, InetAddress address) throws IllegalArgumentException {
        this.eng = engine;
        this.listener = new TrapListener(this);
        this.port = port;
        this.address = address;
        this.packetTaskServer = this.createPacketTaskServer();
        this.callbackTaskServer = this.createCallbackTaskServer();
    }

    public SnmpTrapReceiver(SnmpEngineParameters parameters, SnmpEngineFactory factory, int port, InetAddress address) throws IllegalArgumentException {
        if (parameters == null) {
            parameters = new SnmpEngineParameters();
        }
        if (factory == null) {
            factory = new JdmkEngineFactory();
        }
        this.eng = factory.createEngine(parameters);
        this.listener = new TrapListener(this);
        this.port = port;
        this.address = address;
        this.packetTaskServer = this.createPacketTaskServer();
        this.callbackTaskServer = this.createCallbackTaskServer();
    }

    public void receiveAsGeneric(boolean val) {
        this.receiveAsGeneric = val;
    }

    public synchronized void start() throws SocketException {
        if (this.started) {
            return;
        }
        this.dispatcher = new SnmpEventReportDispatcher(this.eng, this.port, this.address, this.packetTaskServer, this.callbackTaskServer);
        this.dispatcher.addTrapListener(this.listener);
        this.started = true;
        this.dispatchThread = new Thread(this.dispatcher);
        this.dispatchThread.start();
    }

    public synchronized void stop() throws SocketException {
        if (!this.started) {
            return;
        }
        try {
            this.dispatcher.close();
        }
        catch (IOException e) {
            logger.finest("stop", "Exception caught while closing dispatcher: " + e);
        }
        this.started = false;
        this.dispatchThread.interrupt();
    }

    synchronized void receivedV1(SnmpPduTrap trap) {
        if (this.receiveAsGeneric) {
            SnmpTrap gentrap = new SnmpTrap(trap);
            this.receivedTrap(gentrap);
        } else {
            this.receivedV1Trap(trap);
        }
    }

    synchronized void receivedV2(SnmpPduRequest trap) {
        if (this.receiveAsGeneric) {
            SnmpTrap gentrap = new SnmpTrap(trap);
            this.receivedTrap(gentrap);
        } else {
            this.receivedV2Trap(trap);
        }
    }

    synchronized void receivedV3(SnmpScopedPduRequest trap) {
        if (this.receiveAsGeneric) {
            SnmpTrap gentrap = new SnmpTrap(trap);
            this.receivedTrap(gentrap);
        } else {
            this.receivedV3Trap(trap);
        }
    }

    protected TaskServer createPacketTaskServer() {
        DaemonTaskServer ts = new DaemonTaskServer();
        ts.start();
        return ts;
    }

    protected TaskServer createCallbackTaskServer() {
        return null;
    }

    protected Thread createDispatcherThread(Runnable dispatcher) {
        return new Thread(dispatcher, "SnmpTrapReceiver[" + count++ + "]");
    }

    protected void receivedTrap(SnmpTrap trap) {
    }

    protected void receivedV1Trap(SnmpPduTrap trap) {
    }

    protected void receivedV2Trap(SnmpPduRequest trap) {
    }

    protected void receivedV3Trap(SnmpScopedPduRequest trap) {
    }
}

