/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.comm.SnmpAdaptorServer;
import com.sun.management.comm.SnmpV3AdaptorServer;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.snmp.SnmpCounter64;
import com.sun.management.snmp.SnmpIpAddress;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduRequest;
import com.sun.management.snmp.SnmpPduTrap;
import com.sun.management.snmp.SnmpScopedPduRequest;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpString;
import com.sun.management.snmp.SnmpTimeticks;
import com.sun.management.snmp.SnmpUnknownModelException;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.SnmpVarBindList;
import com.sun.management.snmp.manager.SnmpParameters;
import com.sun.management.snmp.manager.SnmpPeer;
import com.sun.management.snmp.manager.usm.SnmpUsmParameters;
import com.sun.management.snmp.manager.usm.SnmpUsmPeer;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;

public class SnmpTrap
implements Serializable {
    private static final long serialVersionUID = 4545122574911175203L;
    public static final SnmpOid coldStartOid = new SnmpOid("1.3.6.1.6.3.1.1.5.1");
    public static final SnmpOid warmStartOid = new SnmpOid("1.3.6.1.6.3.1.1.5.2");
    public static final SnmpOid linkDownOid = new SnmpOid("1.3.6.1.6.3.1.1.5.3");
    public static final SnmpOid linkUpOid = new SnmpOid("1.3.6.1.6.3.1.1.5.4");
    public static final SnmpOid authenticationFailureOid = new SnmpOid("1.3.6.1.6.3.1.1.5.5");
    public static final SnmpOid egpNeighborLossOid = new SnmpOid("1.3.6.1.6.3.1.1.5.6");
    private static final SnmpOid snmpTrapRadicalOid = new SnmpOid("1.3.6.1.6.3.1.1.5");
    public static final SnmpOid snmpTrapSysUpTimeOid = new SnmpOid("1.3.6.1.2.1.1.3.0");
    public static final SnmpOid snmpTrapOid = new SnmpOid("1.3.6.1.6.3.1.1.4.1.0");
    public static final SnmpOid snmpTrapAddressOid = new SnmpOid("1.3.6.1.6.3.18.1.3.0");
    public static final SnmpOid snmpTrapEnterpriseOid = new SnmpOid("1.3.6.1.6.3.1.1.4.3.0");
    public static final SnmpOid snmpTrapsOid = new SnmpOid("1.3.6.1.6.3.1.1.5");
    public static final SnmpOid snmpTrapCommunityOid = new SnmpOid("1.3.6.1.6.3.18.1.4.0");
    String dbgTag = "SnmpTrap";
    InetAddress address = null;
    String communityString = null;
    SnmpOid trapOid = null;
    Integer gen = null;
    Integer specific = null;
    SnmpAdaptorServer server = null;
    SnmpOid enterpriseOid = null;
    SnmpPduTrap pduTrap = null;
    SnmpPduRequest pduRequest = null;
    SnmpVarBindList pduTrapList = null;
    int bufferSize = 1024;
    int port = -1;
    SnmpScopedPduRequest scopedTrap = null;
    private boolean originator = true;
    private InetAddress pduAddr = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpTrap");

    public SnmpTrap(int gen, int specific, SnmpVarBindList varBindList) {
        this.gen = new Integer(gen);
        this.specific = new Integer(specific);
        this.initialize(null, null, varBindList);
    }

    public SnmpTrap(InetAddress addr, String cs, int gen, int specific, SnmpVarBindList varBindList) {
        this.gen = new Integer(gen);
        this.specific = new Integer(specific);
        this.initialize(addr, cs, varBindList);
    }

    public SnmpTrap(SnmpOid trapOid, SnmpVarBindList varBindList) {
        this.trapOid = trapOid;
        this.initialize(null, null, varBindList);
    }

    public SnmpTrap(InetAddress addr, String cs, SnmpOid trapOid, SnmpVarBindList varBindList) {
        this.trapOid = trapOid;
        this.initialize(addr, cs, varBindList);
    }

    public SnmpTrap(SnmpPduTrap trap) {
        this.pduTrap = trap;
        this.convertPduList(trap.varBindList);
    }

    public SnmpTrap(SnmpScopedPduRequest scopedTrap) {
        this.scopedTrap = scopedTrap;
        this.convertPduList(scopedTrap.varBindList);
    }

    public SnmpTrap(SnmpPduRequest trap) {
        this.pduRequest = trap;
        this.convertPduList(trap.varBindList);
    }

    public InetAddress getSourceAddress() {
        if (this.scopedTrap != null) {
            return this.scopedTrap.address;
        }
        if (this.pduRequest != null) {
            return this.pduRequest.address;
        }
        if (this.pduTrap != null) {
            return this.pduTrap.address;
        }
        return null;
    }

    public SnmpPdu getPdu() {
        if (this.scopedTrap != null) {
            return this.scopedTrap;
        }
        if (this.pduRequest != null) {
            return this.pduRequest;
        }
        if (this.pduTrap != null) {
            return this.pduTrap;
        }
        return null;
    }

    public void setEnterpriseOid(String oid) {
        this.enterpriseOid = new SnmpOid(oid);
    }

    public void setDestinationAddress(InetAddress address) {
        this.address = address;
    }

    public void setDestinationPort(int port) {
        this.port = port;
    }

    public void setCommunityString(String cs) {
        this.communityString = cs;
    }

    public void sendV3(SnmpV3AdaptorServer server) throws IOException, SnmpStatusException {
        if (this.scopedTrap == null) {
            throw new SnmpStatusException("No scoped trap. Should use sendV3Usm method");
        }
        if (this.port != -1) {
            SnmpUsmPeer peer = null;
            if (this.getAddress() != null) {
                try {
                    peer = new SnmpUsmPeer(server.getEngine(), this.getAddress().getHostAddress(), this.port, null);
                }
                catch (SnmpUnknownModelException e) {
                    throw new SnmpStatusException("Unknown model: " + e);
                }
                server.snmpV3Trap(peer, this.scopedTrap);
                return;
            }
        }
        server.snmpV3Trap(this.getAddress(), this.scopedTrap);
    }

    public void sendV3Usm(SnmpV3AdaptorServer server, String principal, int securityLevel, String contextName) throws IOException, SnmpStatusException {
        byte[] ctx;
        if (logger.finestOn()) {
            logger.finest("sendV3Trap", "trapOid= " + this.getTrapOid());
        }
        int sendPort = this.port == -1 ? server.getTrapPort() : this.port;
        SnmpEngineImpl engine = (SnmpEngineImpl)server.getEngine();
        SnmpUsmPeer peer = null;
        SnmpUsmParameters p = null;
        if (this.getAddress() != null) {
            if (logger.finestOn()) {
                logger.finest("sendV3Trap", "Create Peer " + this.getAddress() + "/" + sendPort);
            }
            try {
                peer = new SnmpUsmPeer(engine, this.getAddress().getHostAddress(), sendPort, null);
                p = new SnmpUsmParameters(engine);
            }
            catch (SnmpUnknownModelException e) {
                throw new SnmpStatusException("Unknown model: " + e);
            }
            p.setPrincipal(principal);
            p.setSecurityLevel(securityLevel);
            ctx = this.getContext(contextName);
            if (ctx != null) {
                p.setContextName(ctx);
            }
            peer.setParams(p);
        }
        if (peer != null) {
            server.snmpV3UsmTrap(peer, this.getTrapOid(), this.getVarBindList(3), this.getTimeStamp());
        } else {
            ctx = this.getContext(contextName);
            server.snmpV3UsmTrap(this.getAddress(), principal, securityLevel, ctx == null ? null : new String(ctx), this.getTrapOid(), this.getVarBindList(3), this.getTimeStamp());
        }
    }

    public void sendV2(SnmpAdaptorServer server) throws IOException, SnmpStatusException {
        if (logger.finestOn()) {
            logger.finest("sendV2Trap", "trapOid= " + this.getTrapOid());
        }
        int sendPort = this.port == -1 ? server.getTrapPort() : this.port;
        SnmpPeer peer = null;
        SnmpParameters p = null;
        if (this.getAddress() != null) {
            if (logger.finestOn()) {
                logger.finest("sendV2Trap", "Create Peer " + this.getAddress() + "/" + sendPort);
            }
            peer = new SnmpPeer(this.getAddress().getHostAddress(), sendPort);
            p = new SnmpParameters();
            p.setRdCommunity(this.getCommunity());
            peer.setParams(p);
        }
        if (logger.finestOn()) {
            logger.finest("sendV2Trap", "pduRequest is not provided");
        }
        if (peer == null) {
            server.snmpV2Trap(this.getAddress(), this.getCommunity(), this.getTrapOid(), this.getVarBindList(1), this.getTimeStamp());
        } else {
            server.snmpV2Trap(peer, this.getTrapOid(), this.getVarBindList(1), this.getTimeStamp());
        }
    }

    public void sendV1(SnmpAdaptorServer server) throws IOException, SnmpStatusException {
        if (logger.finestOn()) {
            logger.finest("snmpV1Trap", "generic = " + this.getGeneric());
        }
        int sendPort = this.port == -1 ? server.getTrapPort() : this.port;
        SnmpPeer peer = null;
        SnmpParameters p = null;
        boolean version = false;
        if (this.getAddress() != null) {
            if (logger.finestOn()) {
                logger.finest("sendV1Trap", "Create Peer " + this.getAddress() + "/" + sendPort);
            }
            peer = new SnmpPeer(this.getAddress().getHostAddress(), sendPort);
            p = new SnmpParameters();
            p.setRdCommunity(this.getCommunity());
            peer.setParams(p);
        }
        if (peer == null) {
            server.snmpV1Trap(this.getAddress(), this.getAgentAddr(), this.getCommunity(), this.getEnterpriseOid(), this.getGeneric(), this.getSpecific(), this.getVarBindList(0), this.getTimeStamp());
        } else {
            server.snmpV1Trap(peer, this.getAgentAddr(), this.getEnterpriseOid(), this.getGeneric(), this.getSpecific(), this.getVarBindList(0), this.getTimeStamp());
        }
    }

    private SnmpOid getTrapOid() {
        if (this.trapOid != null) {
            return this.trapOid;
        }
        if (this.pduRequest != null || this.scopedTrap != null) {
            SnmpVarBindList l = this.pduTrapList;
            int pos = l.indexOfOid(snmpTrapOid);
            SnmpVarBind var = l.getVarBindAt(pos);
            return (SnmpOid)var.getSnmpValue();
        }
        return this.calculateTrapOid();
    }

    private int getGeneric() {
        if (this.gen != null) {
            return this.gen;
        }
        if (this.pduTrap != null) {
            return this.pduTrap.genericTrap;
        }
        return this.calculateGeneric();
    }

    private int getSpecific() {
        if (this.specific != null) {
            return this.specific;
        }
        if (this.pduTrap != null) {
            return this.pduTrap.specificTrap;
        }
        return this.calculateSpecific();
    }

    private InetAddress getAddress() {
        return this.address;
    }

    private String getCommunity() {
        if (this.communityString != null) {
            return this.communityString;
        }
        if (this.pduTrap != null && this.pduTrap.community != null) {
            return new String(this.pduTrap.community);
        }
        if (this.pduRequest != null && this.pduRequest.community != null) {
            return new String(this.pduRequest.community);
        }
        if (this.scopedTrap != null && this.scopedTrap.contextName != null) {
            return new String(this.scopedTrap.contextName);
        }
        return null;
    }

    private byte[] getContext(String contextName) {
        if (contextName != null) {
            return contextName.getBytes();
        }
        if (this.pduTrap != null) {
            return this.pduTrap.community;
        }
        if (this.pduRequest != null) {
            return this.pduRequest.community;
        }
        if (this.scopedTrap != null) {
            return this.scopedTrap.contextName;
        }
        return null;
    }

    private SnmpOid getEnterpriseOid() {
        if (this.enterpriseOid != null) {
            return this.enterpriseOid;
        }
        if (this.pduTrap != null) {
            return this.pduTrap.enterprise;
        }
        return this.calculateEnterpriseOid();
    }

    private SnmpVarBindList getVarBindList(int vers) throws SnmpStatusException {
        if (logger.finestOn()) {
            logger.finest("getVarBindList", "Calculate varbindlist for version : " + vers);
        }
        switch (vers) {
            case 1: 
            case 3: {
                return this.calculateV2VarBindList();
            }
            case 0: {
                return this.calculateV1VarBindList();
            }
        }
        throw new SnmpStatusException("getVarBindList: Unable to define varBindList.");
    }

    private SnmpVarBindList getFullV2VarBindList() {
        SnmpVarBindList lst = this.calculateV2VarBindList();
        int found = lst.indexOfOid(snmpTrapOid);
        if (found == -1) {
            if (logger.finestOn()) {
                logger.finest("getFullV2VarBindList", "Must add trapOid : " + this.getTrapOid());
            }
            lst.insertElementAt(new SnmpVarBind(snmpTrapOid, this.getTrapOid()), 0);
        }
        if ((found = lst.indexOfOid(snmpTrapSysUpTimeOid)) == -1) {
            if (logger.finestOn()) {
                logger.finest("getFullV2VarBindList", "Must add timeStamp : " + this.getTimeStamp());
            }
            lst.insertElementAt(new SnmpVarBind(snmpTrapSysUpTimeOid, this.getTimeStamp()), 0);
        }
        if (logger.finestOn()) {
            logger.finest("getFullV2VarBindList", "List updated");
        }
        return lst;
    }

    private SnmpTimeticks getTimeStamp() {
        if (this.pduTrap != null) {
            return new SnmpTimeticks(this.pduTrap.timeStamp);
        }
        if (this.pduRequest != null || this.scopedTrap != null) {
            int pos = this.pduTrapList.indexOfOid(snmpTrapSysUpTimeOid);
            SnmpVarBind var = this.pduTrapList.getVarBindAt(pos);
            return (SnmpTimeticks)var.getSnmpValue();
        }
        return null;
    }

    public void sendAsNotificationOriginator() {
        this.originator = true;
    }

    public void sendAsProxy() {
        this.originator = false;
    }

    public boolean isOriginatorWay() {
        return this.originator;
    }

    public boolean isProxyWay() {
        return !this.isOriginatorWay();
    }

    public void setPduSourceAddress(InetAddress addr) {
        this.pduAddr = addr;
    }

    private SnmpIpAddress handleMultipleIpVersion(byte[] address) {
        if (address.length == 4) {
            return new SnmpIpAddress(address);
        }
        if (logger.finestOn()) {
            logger.finest("handleMultipleIPVersion", "Not an IPv4 address, return null");
        }
        return null;
    }

    private SnmpIpAddress getAgentAddr() {
        if (this.isOriginatorWay()) {
            if (this.pduAddr != null) {
                return this.handleMultipleIpVersion(this.pduAddr.getAddress());
            }
            if (logger.finestOn()) {
                logger.finest("getAgentAddr", "Originator way, let the SnmpAdaptor handling the source address");
            }
            return null;
        }
        if (this.pduTrap != null) {
            return this.pduTrap.agentAddr;
        }
        if (this.pduRequest != null || this.scopedTrap != null) {
            int pos = this.pduTrapList.indexOfOid(snmpTrapAddressOid);
            if (pos != -1) {
                SnmpVarBind var = this.pduTrapList.getVarBindAt(pos);
                return (SnmpIpAddress)var.getSnmpValue();
            }
            return new SnmpIpAddress("0.0.0.0");
        }
        return null;
    }

    private int calculateGeneric() {
        SnmpOid oid = null;
        if (this.trapOid != null) {
            oid = this.trapOid;
        } else {
            SnmpVarBindList l = this.pduTrapList;
            int pos = l.indexOfOid(snmpTrapOid);
            SnmpVarBind var = l.getVarBindAt(pos);
            oid = (SnmpOid)var.getSnmpValue();
        }
        if (oid.equals(coldStartOid)) {
            return 0;
        }
        if (oid.equals(warmStartOid)) {
            return 1;
        }
        if (oid.equals(linkDownOid)) {
            return 2;
        }
        if (oid.equals(linkUpOid)) {
            return 3;
        }
        if (oid.equals(authenticationFailureOid)) {
            return 4;
        }
        if (oid.equals(egpNeighborLossOid)) {
            return 5;
        }
        return 6;
    }

    private int calculateSpecific() {
        SnmpOid oid = null;
        if (this.trapOid != null) {
            oid = this.trapOid;
        } else {
            SnmpVarBindList l = this.pduTrapList;
            int pos = l.indexOfOid(snmpTrapOid);
            SnmpVarBind var = l.getVarBindAt(pos);
            oid = (SnmpOid)var.getSnmpValue();
        }
        if (this.getGeneric() == 6) {
            int val = 0;
            try {
                val = (int)oid.getOidArc(oid.getLength() - 1);
            }
            catch (SnmpStatusException snmpStatusException) {
                // empty catch block
            }
            return val;
        }
        return 0;
    }

    private SnmpOid calculateTrapOid() {
        SnmpOid trap = null;
        int g = 0;
        int spec = 0;
        if (this.pduTrap != null) {
            g = this.pduTrap.genericTrap;
            spec = this.pduTrap.specificTrap;
        } else {
            g = this.gen;
            spec = this.specific;
        }
        switch (g) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                trap = new SnmpOid(snmpTrapRadicalOid.longValue());
                trap.append(g + 1);
                break;
            }
            default: {
                trap = this.enterpriseOid != null ? new SnmpOid(snmpTrapEnterpriseOid.longValue()) : new SnmpOid(this.pduTrap.enterprise.longValue());
                trap.append(0L);
                trap.append(spec);
            }
        }
        return trap;
    }

    private SnmpOid calculateEnterpriseOid() {
        int pos = this.pduTrapList.indexOfOid(snmpTrapOid);
        if (pos == -1) {
            return null;
        }
        SnmpVarBind var = this.pduTrapList.getVarBindAt(pos);
        SnmpOid trapOid = (SnmpOid)var.getSnmpValue();
        if (SnmpTrap.isStandardTrap(trapOid)) {
            int p = this.pduTrapList.indexOfOid(snmpTrapEnterpriseOid);
            if (p != -1) {
                SnmpVarBind v = this.pduTrapList.getVarBindAt(p);
                return (SnmpOid)v.getSnmpValue();
            }
            return snmpTrapsOid;
        }
        long[] tabOid = trapOid.longValue();
        long key = tabOid[tabOid.length - 2];
        int limit = 0;
        limit = key == 0L ? 2 : 1;
        long[] target = new long[tabOid.length - limit];
        for (int i = 0; i < target.length; ++i) {
            target[i] = tabOid[i];
        }
        return new SnmpOid(target);
    }

    private static boolean isStandardTrap(SnmpOid oid) {
        return oid.equals(coldStartOid) || oid.equals(warmStartOid) || oid.equals(linkUpOid) || oid.equals(linkDownOid) || oid.equals(authenticationFailureOid) || oid.equals(egpNeighborLossOid);
    }

    private SnmpVarBindList calculateV1VarBindList() throws SnmpStatusException {
        SnmpVarBindList list = new SnmpVarBindList();
        for (int i = 0; i < this.pduTrapList.size(); ++i) {
            SnmpVarBind var = this.pduTrapList.getVarBindAt(i);
            if (var.getSnmpValue() instanceof SnmpCounter64) {
                throw new SnmpStatusException(2, i);
            }
            list.addVarBind(var);
        }
        return list;
    }

    private SnmpVarBindList calculateV2VarBindList() {
        if (this.pduTrap == null) {
            return this.pduTrapList;
        }
        if (this.isOriginatorWay()) {
            return this.pduTrapList;
        }
        SnmpVarBindList list = new SnmpVarBindList(this.pduTrapList);
        boolean toadd = false;
        int found = this.pduTrapList.indexOfOid(snmpTrapAddressOid);
        if (found == -1) {
            toadd = true;
        }
        if ((found = this.pduTrapList.indexOfOid(snmpTrapCommunityOid)) == -1) {
            toadd = true;
        }
        if ((found = this.pduTrapList.indexOfOid(snmpTrapEnterpriseOid)) == -1) {
            toadd = true;
        }
        if (toadd) {
            if (logger.finestOn()) {
                logger.finest("calculateV2VarBindList", "Must add varbind");
            }
            list.addVarBind(new SnmpVarBind(snmpTrapAddressOid, this.pduTrap.agentAddr));
            SnmpString co = new SnmpString(this.pduTrap.community);
            list.addVarBind(new SnmpVarBind(snmpTrapCommunityOid, co));
            list.addVarBind(new SnmpVarBind(snmpTrapEnterpriseOid, this.pduTrap.enterprise));
        }
        return list;
    }

    private void convertPduList(SnmpVarBind[] vars) {
        this.pduTrapList = new SnmpVarBindList();
        for (int i = 0; i < vars.length; ++i) {
            this.pduTrapList.addVarBind(vars[i]);
        }
    }

    private SnmpVarBind[] toVarBindArray(SnmpVarBindList l) {
        SnmpVarBind[] arr = new SnmpVarBind[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            arr[i] = l.getVarBindAt(i);
        }
        return arr;
    }

    private void initialize(InetAddress address, String cs, SnmpVarBindList varBindList) {
        this.address = address;
        this.communityString = cs;
        this.pduTrapList = varBindList;
    }
}

