/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.manager.SnmpPeer;
import com.sun.management.snmp.manager.SnmpSession;

class SnmpSessionProvider {
    private SnmpSession fixSession;
    private SnmpSession session;
    private int peerVersion;
    private String dbgTag;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpSessionProvider");

    public SnmpSessionProvider(SnmpPeer peer, SnmpSession session) {
        block2: {
            this.fixSession = null;
            this.session = null;
            this.peerVersion = 0;
            this.dbgTag = "SnmpSessionProvider";
            try {
                this.peerVersion = peer.getParams().getProtocolVersion();
                this.session = session;
                SnmpEngine engine = session.getEngine();
                session.setDefaultPeer(peer);
                session.snmpOptions.setPduFixedOnError(false);
                this.fixSession = new SnmpSession(engine, "Fixed error Snmp session", null);
                this.fixSession.setDefaultPeer(peer);
                this.fixSession.snmpOptions.setPduFixedOnError(true);
            }
            catch (SnmpStatusException e) {
                if (!logger.finestOn()) break block2;
                logger.finest("SnmpSessionProvider", e);
            }
        }
    }

    SnmpSession getSession(int managerVersion) {
        if (logger.finestOn()) {
            logger.finest("getSession", "Manager protocol : " + managerVersion + "\nPeer protocol :" + this.peerVersion);
        }
        if (this.peerVersion == managerVersion) {
            return this.session;
        }
        if (this.peerVersion == 0) {
            if (logger.finestOn()) {
                logger.finest("getSession", "Return fixed session");
            }
            return this.fixSession;
        }
        return this.session;
    }

    SnmpSession getDefaultSession() {
        return this.session;
    }

    public synchronized void hideInvalidResponseError(boolean hide) {
        this.session.hideInvalidResponseError(hide);
        this.fixSession.hideInvalidResponseError(hide);
    }

    public synchronized boolean isInvalidResponseErrorHidden() {
        return this.session.isInvalidResponseErrorHidden();
    }
}

