/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.agent.SnmpMibRequest;
import com.sun.management.snmp.agent.SnmpRequestTree;
import java.util.Enumeration;
import java.util.Vector;

final class SnmpMibRequestImpl
implements SnmpMibRequest {
    private Vector varbinds;
    private int version;
    private Object data;
    private SnmpPdu reqPdu = null;
    private SnmpRequestTree tree = null;
    private SnmpEngine engine = null;
    private String principal = null;
    private int securityLevel = -1;
    private int securityModel = -1;
    private byte[] contextName = null;
    private byte[] accessContextName = null;

    public SnmpMibRequestImpl(SnmpPdu reqPdu, Vector vblist, int protocolVersion, Object userData) {
        this.varbinds = vblist;
        this.version = protocolVersion;
        this.data = userData;
        this.reqPdu = reqPdu;
    }

    public SnmpMibRequestImpl(SnmpEngine engine, SnmpPdu reqPdu, Vector vblist, int protocolVersion, Object userData, String principal, int securityLevel, int securityModel, byte[] contextName, byte[] accessContextName) {
        this.varbinds = vblist;
        this.version = protocolVersion;
        this.data = userData;
        this.reqPdu = reqPdu;
        this.engine = engine;
        this.principal = principal;
        this.securityLevel = securityLevel;
        this.securityModel = securityModel;
        this.contextName = contextName;
        this.accessContextName = accessContextName;
    }

    public SnmpEngine getEngine() {
        return this.engine;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public int getSecurityLevel() {
        return this.securityLevel;
    }

    public int getSecurityModel() {
        return this.securityModel;
    }

    public byte[] getContextName() {
        return this.contextName;
    }

    public byte[] getAccessContextName() {
        return this.accessContextName;
    }

    public final SnmpPdu getPdu() {
        return this.reqPdu;
    }

    public final Enumeration getElements() {
        return this.varbinds.elements();
    }

    public final Vector getSubList() {
        return this.varbinds;
    }

    public final int getSize() {
        if (this.varbinds == null) {
            return 0;
        }
        return this.varbinds.size();
    }

    public final int getVersion() {
        return this.version;
    }

    public final int getRequestPduVersion() {
        return this.reqPdu.version;
    }

    public final Object getUserData() {
        return this.data;
    }

    public final int getVarIndex(SnmpVarBind varbind) {
        return this.varbinds.indexOf(varbind);
    }

    public void addVarBind(SnmpVarBind varbind) {
        this.varbinds.addElement(varbind);
    }

    final void setRequestTree(SnmpRequestTree tree) {
        this.tree = tree;
    }

    final SnmpRequestTree getRequestTree() {
        return this.tree;
    }

    final Vector getVarbinds() {
        return this.varbinds;
    }
}

