/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.comm.SnmpAdaptorServer;
import com.sun.management.comm.SnmpInformHandler;
import com.sun.management.comm.SnmpInformRequest;
import com.sun.management.comm.SnmpQManager;
import com.sun.management.comm.SnmpResponseHandler;
import com.sun.management.comm.SnmpSocket;
import com.sun.management.snmp.SnmpDefinitions;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpVarBindList;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;

class SnmpSession
implements SnmpDefinitions,
Runnable {
    protected transient SnmpAdaptorServer adaptor;
    protected transient SnmpSocket informSocket = null;
    private transient Hashtable informRequestList = new Hashtable();
    private transient Stack informRespq = new Stack();
    private transient Thread myThread = null;
    private transient SnmpInformRequest syncInformReq;
    SnmpQManager snmpQman = null;
    String dbgTag = "SnmpSession";
    private boolean isBeingCanceled = false;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.adaptor", "SnmpSession");

    public SnmpSession(SnmpAdaptorServer adp) throws SocketException {
        this.adaptor = adp;
        this.snmpQman = new SnmpQManager();
        SnmpResponseHandler snmpRespHdlr = new SnmpResponseHandler(adp, this.snmpQman);
        this.initialize(adp, snmpRespHdlr);
    }

    public SnmpSession() throws SocketException {
    }

    protected synchronized void initialize(SnmpAdaptorServer adp, SnmpResponseHandler snmpRespHdlr) throws SocketException {
        this.informSocket = new SnmpSocket(snmpRespHdlr, adp.getAddress(), adp.getBufferSize());
        this.myThread = new Thread((Runnable)this, "SnmpSession");
        this.myThread.start();
    }

    synchronized boolean isSessionActive() {
        return this.adaptor.isActive() && this.myThread != null && this.myThread.isAlive();
    }

    SnmpSocket getSocket() {
        return this.informSocket;
    }

    SnmpQManager getSnmpQManager() {
        return this.snmpQman;
    }

    private synchronized boolean syncInProgress() {
        return this.syncInformReq != null;
    }

    private synchronized void setSyncMode(SnmpInformRequest req) {
        this.syncInformReq = req;
    }

    private synchronized void resetSyncMode() {
        if (this.syncInformReq == null) {
            return;
        }
        this.syncInformReq = null;
        if (this.thisSessionContext()) {
            return;
        }
        this.notifyAll();
    }

    boolean thisSessionContext() {
        return Thread.currentThread() == this.myThread;
    }

    SnmpInformRequest makeAsyncRequest(InetAddress addr, String cs, SnmpInformHandler cb, SnmpVarBindList vblst, int port) throws SnmpStatusException {
        if (!this.isSessionActive()) {
            throw new SnmpStatusException("SNMP adaptor server not ONLINE");
        }
        SnmpInformRequest snmpreq = new SnmpInformRequest(this, this.adaptor, addr, cs, port, cb);
        snmpreq.start(vblst);
        return snmpreq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForResponse(SnmpInformRequest req, long waitTime) {
        if (!req.inProgress()) {
            return;
        }
        this.setSyncMode(req);
        if (logger.finerOn()) {
            logger.finer("waitForResponse", "Session switching to sync mode for inform request " + req.getRequestId());
        }
        long maxTime = waitTime <= 0L ? System.currentTimeMillis() + 6000000L : System.currentTimeMillis() + waitTime;
        while ((req.inProgress() || this.syncInProgress()) && (waitTime = maxTime - System.currentTimeMillis()) > 0L) {
            SnmpSession snmpSession = this;
            synchronized (snmpSession) {
                if (!this.informRespq.removeElement(req)) {
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    continue;
                }
            }
            try {
                this.processResponse(req);
            }
            catch (Exception e) {
                if (!logger.finestOn()) continue;
                logger.finest("waitForResponse", e);
            }
        }
        this.resetSyncMode();
    }

    public void run() {
        this.myThread = Thread.currentThread();
        this.myThread.setPriority(5);
        SnmpInformRequest reqc = null;
        while (this.myThread != null) {
            try {
                reqc = this.nextResponse();
                if (reqc == null) continue;
                this.processResponse(reqc);
            }
            catch (ThreadDeath d) {
                this.myThread = null;
                if (logger.finestOn()) {
                    logger.finest("run", "Session thread unexpectedly shutting down");
                }
                throw d;
            }
        }
        if (logger.finerOn()) {
            logger.finer("run", "Session thread shutting down");
        }
        this.myThread = null;
    }

    private void processResponse(SnmpInformRequest reqc) {
        while (reqc != null && this.myThread != null) {
            try {
                if (reqc == null) continue;
                if (logger.finerOn()) {
                    logger.finer("processResponse", "Processing response to req = " + reqc.getRequestId());
                }
                reqc.processResponse();
                reqc = null;
            }
            catch (Exception e) {
                if (logger.finestOn()) {
                    logger.finest("processResponse", e);
                }
                reqc = null;
            }
            catch (OutOfMemoryError ome) {
                if (logger.finestOn()) {
                    logger.finest("processResponse", "Out of memory error in session thread");
                    logger.finest("processResponse", ome);
                }
                Thread.currentThread();
                Thread.yield();
            }
        }
    }

    synchronized void addInformRequest(SnmpInformRequest snmpreq) throws SnmpStatusException {
        if (!this.isSessionActive()) {
            throw new SnmpStatusException("SNMP adaptor is not ONLINE or session is dead...");
        }
        this.informRequestList.put(snmpreq, snmpreq);
    }

    synchronized void removeInformRequest(SnmpInformRequest snmpreq) {
        if (!this.isBeingCanceled) {
            this.informRequestList.remove(snmpreq);
        }
        if (this.syncInformReq != null && this.syncInformReq == snmpreq) {
            this.resetSyncMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAllRequests() {
        SnmpInformRequest[] list;
        SnmpSession snmpSession = this;
        synchronized (snmpSession) {
            if (this.informRequestList.isEmpty()) {
                return;
            }
            this.isBeingCanceled = true;
            list = new SnmpInformRequest[this.informRequestList.size()];
            Iterator it = this.informRequestList.values().iterator();
            int i = 0;
            while (it.hasNext()) {
                SnmpInformRequest req = (SnmpInformRequest)it.next();
                list[i++] = req;
                it.remove();
            }
            this.informRequestList.clear();
        }
        for (int i = 0; i < list.length; ++i) {
            list[i].cancelRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addResponse(SnmpInformRequest reqc) {
        SnmpInformRequest snmpreq = reqc;
        if (this.isSessionActive()) {
            SnmpSession snmpSession = this;
            synchronized (snmpSession) {
                this.informRespq.push(reqc);
                this.notifyAll();
            }
        } else if (logger.finestOn()) {
            logger.finest("addResponse", "Adaptor not ONLINE or session thread dead. So inform response is dropped..." + reqc.getRequestId());
        }
    }

    private synchronized SnmpInformRequest nextResponse() {
        if (this.informRespq.isEmpty()) {
            try {
                if (logger.finerOn()) {
                    logger.finer("nextResponse", "Blocking for response");
                }
                this.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.informRespq.isEmpty()) {
            return null;
        }
        SnmpInformRequest reqc = (SnmpInformRequest)this.informRespq.firstElement();
        this.informRespq.removeElementAt(0);
        return reqc;
    }

    private synchronized void cancelAllResponses() {
        if (this.informRespq != null) {
            this.syncInformReq = null;
            this.informRespq.removeAllElements();
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void destroySession() {
        this.cancelAllRequests();
        this.cancelAllResponses();
        SnmpSession snmpSession = this;
        synchronized (snmpSession) {
            this.informSocket.close();
            this.informSocket = null;
        }
        this.snmpQman.stopQThreads();
        this.snmpQman = null;
        this.killSessionThread();
    }

    private synchronized void killSessionThread() {
        if (this.myThread != null && this.myThread.isAlive()) {
            if (logger.finerOn()) {
                logger.finer("killSessionThread", "Destroying session");
            }
            if (!this.thisSessionContext()) {
                this.myThread = null;
                this.notifyAll();
            } else {
                this.myThread = null;
            }
        }
    }

    public void finalize() {
        if (this.informRespq != null) {
            this.informRespq.removeAllElements();
        }
        this.informRespq = null;
        if (this.informSocket != null) {
            this.informSocket.close();
        }
        this.informSocket = null;
        if (logger.finerOn()) {
            logger.finer("finalize", "Shutting all servers");
        }
        this.snmpQman = null;
    }
}

