/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.internal.ClassLogger;
import java.net.InetAddress;

public class RmiConnectorAddress
implements ConnectorAddress {
    private static final long serialVersionUID = -3866575485397551102L;
    private String host = null;
    private int defaultPort;
    private int port = this.defaultPort = 1099;
    private String defaultServiceName;
    private String serviceName = this.defaultServiceName = "name=RmiConnectorServer";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.comm.legacy.connector.rmi", "RmiConnectorAddress");

    public RmiConnectorAddress() {
        if (System.getProperty("jdmk.hostname") != null) {
            this.host = System.getProperty("jdmk.hostname");
        } else {
            try {
                this.host = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                this.host = "localhost";
            }
        }
        if (logger.finerOn()) {
            logger.finer("RmiConnectorAddress", "host=" + this.host);
        }
    }

    public RmiConnectorAddress(String host, int port, String serviceName) {
        this.port = port;
        this.serviceName = serviceName;
        if (host != null) {
            this.host = host;
        } else {
            try {
                this.host = System.getProperty("jdmk.hostname") != null ? System.getProperty("jdmk.hostname") : InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                this.host = "localhost";
            }
        }
        if (logger.finerOn()) {
            logger.finer("RmiConnectorAddress", "host=" + this.host);
        }
    }

    public String getConnectorType() {
        return "SUN RMI";
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getName() {
        return this.serviceName;
    }

    public void setName(String serviceName) {
        this.serviceName = serviceName;
    }
}

