/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.mam;

import tigase.component.PacketWriter;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Message;
import tigase.server.Priority;
import tigase.util.datetime.TimestampHelper;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.mam.MAMRepository;
import tigase.xmpp.mam.Query;
import tigase.xmpp.mam.modules.QueryModule;

@Bean(name="mamItemHandler", parent=QueryModule.class, active=true)
public class MAMItemHandler
implements MAMRepository.ItemHandler {
    private static final TimestampHelper TIMESTAMP_FORMATTER = new TimestampHelper();
    private static final System.Logger log = System.getLogger(MAMItemHandler.class.getName());
    @Inject
    private PacketWriter packetWriter;

    public void itemFound(Query query, MAMRepository.Item item) {
        Element m = new Element("message");
        Element result = new Element("result", new String[]{"xmlns", "id"}, new String[]{query.getXMLNS(), item.getId()});
        if (query.getId() != null) {
            result.setAttribute("queryid", query.getId());
        }
        m.addChild((XMLNodeIfc)result);
        Element forwarded = new Element("forwarded", new String[]{"xmlns"}, new String[]{"urn:xmpp:forward:0"});
        result.addChild((XMLNodeIfc)forwarded);
        String timestampStr = TIMESTAMP_FORMATTER.formatWithMs(item.getTimestamp());
        Element delay = new Element("delay", new String[]{"xmlns", "stamp"}, new String[]{"urn:xmpp:delay", timestampStr});
        forwarded.addChild((XMLNodeIfc)delay);
        if (item.getMessage() != null) {
            forwarded.addChild((XMLNodeIfc)item.getMessage());
        }
        Message packet = new Message(m, query.getComponentJID(), query.getQuestionerJID());
        packet.setXMLNS("jabber:client");
        packet.setPriority(Priority.HIGH);
        if (query.getRsm().getFirst() == null) {
            query.getRsm().setFirst(item.getId());
        }
        query.getRsm().setLast(item.getId());
        log.log(System.Logger.Level.TRACE, () -> "Processing item: " + item + " from query: " + query + ", resulting packet: " + packet);
        this.packetWriter.write(packet);
    }
}

