/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Consumer;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.server.PolicyViolationException;
import tigase.server.xmppsession.SessionManager;
import tigase.util.Base64;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessorAbstract;
import tigase.xmpp.XMPPProcessorException;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.annotation.AnnotatedXMPPProcessor;
import tigase.xmpp.impl.annotation.DiscoFeatures;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.impl.roster.RosterFactory;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Id(value="urn:xmpp:mix:pam:2")
@Bean(name="urn:xmpp:mix:pam:2", parent=SessionManager.class, active=true)
@Handles(value={@Handle(path={"iq", "client-join"}, xmlns="urn:xmpp:mix:pam:2"), @Handle(path={"iq", "client-leave"}, xmlns="urn:xmpp:mix:pam:2"), @Handle(path={"iq", "join"}, xmlns="urn:xmpp:mix:core:1"), @Handle(path={"iq", "leave"}, xmlns="urn:xmpp:mix:core:1")})
@DiscoFeatures(value={"urn:xmpp:mix:pam:2"})
public class MIXProcessor
extends AnnotatedXMPPProcessor
implements XMPPProcessorIfc {
    public static final String ID = "urn:xmpp:mix:pam:2";
    @Inject
    private UserRepository userRepository;
    private static final RosterAbstract rosterUtil = RosterFactory.getRosterImplementation(true);
    private static final EnumSet<StanzaType> RESPONSE_TYPES = EnumSet.of(StanzaType.result, StanzaType.error);

    @Override
    public Authorization canHandle(Packet packet, XMPPResourceConnection conn) {
        Authorization result = super.canHandle(packet, conn);
        if (result == Authorization.AUTHORIZED) {
            if (packet.getElement().findChild(el -> el.getXMLNS() == ID) != null) {
                return conn != null ? result : null;
            }
            if (RESPONSE_TYPES.contains((Object)packet.getType())) {
                return packet.getStanzaTo() != null && packet.getStanzaTo().getResource() == null ? result : null;
            }
            return null;
        }
        return result;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        block27: {
            try {
                if (XMPPProcessorAbstract.isFromUserSession(packet, session)) {
                    Element actionEl = packet.getElement().findChild(el -> el.getXMLNS() == ID);
                    if (actionEl == null || !EnumSet.of(StanzaType.set).contains((Object)packet.getType())) {
                        throw new XMPPProcessorException(Authorization.BAD_REQUEST);
                    }
                    BareJID channel = Optional.ofNullable(actionEl.getAttributeStaticStr("channel")).map(BareJID::bareJIDInstanceNS).orElseThrow(() -> new XMPPProcessorException(Authorization.BAD_REQUEST));
                    String id = packet.getStanzaId();
                    if (id == null) {
                        throw new XMPPProcessorException(Authorization.BAD_REQUEST);
                    }
                    switch (actionEl.getName()) {
                        case "client-join": {
                            Element joinEl = Optional.ofNullable(actionEl.getChildStaticStr("join", "urn:xmpp:mix:core:1")).orElseThrow(() -> new XMPPProcessorException(Authorization.BAD_REQUEST));
                            session.setData(ID, this.generateId(channel, id), session.getResource());
                            this.sendToChannel(session.getBareJID(), channel, id, joinEl, results::offer);
                            break;
                        }
                        case "client-leave": {
                            Element leaveEl = Optional.ofNullable(actionEl.getChildStaticStr("leave", "urn:xmpp:mix:core:1")).orElseThrow(() -> new XMPPProcessorException(Authorization.BAD_REQUEST));
                            session.setData(ID, this.generateId(channel, id), session.getResource());
                            this.sendToChannel(session.getBareJID(), channel, id, leaveEl, results::offer);
                            break;
                        }
                        default: {
                            throw new XMPPProcessorException(Authorization.BAD_REQUEST);
                        }
                    }
                    break block27;
                }
                BareJID channel = packet.getStanzaFrom().getBareJID();
                if (packet.getStanzaId() != null && EnumSet.of(StanzaType.result, StanzaType.error).contains((Object)packet.getType())) {
                    String requestId;
                    BareJID userJID = packet.getStanzaTo().getBareJID();
                    String resource = this.userRepository.getData(userJID, ID, requestId = this.generateId(channel, packet.getStanzaId()), null);
                    if (resource == null) {
                        return;
                    }
                    Element actionEl = packet.getElement().findChild(el -> el.getXMLNS() == "urn:xmpp:mix:core:1");
                    this.userRepository.removeData(userJID, ID, requestId);
                    if (packet.getType() == StanzaType.result) {
                        JID channelJID = JID.jidInstance((BareJID)channel);
                        RosterElement item = new RosterElement(channelJID, null, null);
                        item.setSubscription(RosterAbstract.SubscriptionType.both);
                        item.setMixParticipantId(actionEl.getAttributeStaticStr("id"));
                        switch (actionEl.getName()) {
                            case "join": {
                                results.addAll(rosterUtil.addJidToRoster(this.userRepository, session == null ? null : session.getParentSession(), userJID, item));
                                break;
                            }
                            case "leave": {
                                results.addAll(rosterUtil.removeJidFromRoster(this.userRepository, session == null ? null : session.getParentSession(), userJID, channelJID));
                            }
                        }
                        Optional.ofNullable(session).map(XMPPResourceConnection::getParentSession).map(parent -> parent.getResourceForResource(resource)).map(conn -> {
                            try {
                                return conn.getConnectionId();
                            }
                            catch (NoConnectionIdException ex) {
                                return null;
                            }
                        }).ifPresent(connJID -> {
                            Element actionElCopy = actionEl.clone();
                            String id = actionEl.getAttributeStaticStr("id");
                            if (id != null) {
                                actionElCopy.setAttribute("jid", actionEl.getAttributeStaticStr("id") + "#" + channel.toString());
                            }
                            this.sendToUser(userJID, resource, (JID)connJID, packet.getType(), packet.getStanzaId(), actionElCopy, null, results::offer);
                        });
                    } else if (packet.getType() == StanzaType.error) {
                        Optional.ofNullable(session).map(XMPPResourceConnection::getParentSession).map(parent -> parent.getResourceForResource(resource)).map(conn -> {
                            try {
                                return conn.getConnectionId();
                            }
                            catch (NoConnectionIdException ex) {
                                return null;
                            }
                        }).ifPresent(connJID -> {
                            Element actionElCopy = actionEl.clone();
                            actionElCopy.setAttribute("jid", actionEl.getAttributeStaticStr("id") + "#" + channel.toString());
                            this.sendToUser(userJID, resource, (JID)connJID, packet.getType(), packet.getStanzaId(), actionElCopy, packet.getElement().findChild(el -> el.getName() == "error"), results::offer);
                        });
                    }
                    break block27;
                }
                throw new XMPPProcessorException(Authorization.BAD_REQUEST);
            }
            catch (PolicyViolationException ex) {
                throw new XMPPProcessorException(Authorization.POLICY_VIOLATION, ex.getMessage(), ex);
            }
            catch (TigaseDBException ex) {
                throw new XMPPProcessorException(Authorization.INTERNAL_SERVER_ERROR, "Cound not access database", ex);
            }
        }
    }

    protected void sendToChannel(BareJID userJID, BareJID channel, String id, Element actionEl, Consumer<Packet> writer) {
        Element iqEl = new Element("iq");
        iqEl.setXMLNS("jabber:client");
        iqEl.setAttribute("id", id);
        iqEl.setAttribute("type", "set");
        iqEl.addChild((XMLNodeIfc)actionEl);
        writer.accept(Packet.packetInstance(iqEl, JID.jidInstance((BareJID)userJID), JID.jidInstance((BareJID)channel)));
    }

    protected void sendToUser(BareJID userJID, String resource, JID connectionJID, StanzaType stanzaType, String id, Element actionEl, Element errorEl, Consumer<Packet> writer) {
        Element iqEl = new Element("iq");
        iqEl.setXMLNS("jabber:client");
        iqEl.setAttribute("id", id);
        if (stanzaType != null) {
            iqEl.setAttribute("type", stanzaType.toString());
        }
        if (actionEl != null) {
            Element wrapEl = null;
            switch (actionEl.getName()) {
                case "join": {
                    wrapEl = new Element("client-join");
                    break;
                }
                case "leave": {
                    wrapEl = new Element("client-leave");
                    break;
                }
            }
            if (wrapEl != null) {
                wrapEl.setXMLNS(ID);
                wrapEl.addChild((XMLNodeIfc)actionEl);
                iqEl.addChild((XMLNodeIfc)wrapEl);
            }
        }
        if (errorEl != null) {
            iqEl.addChild((XMLNodeIfc)errorEl);
        }
        Packet response = Packet.packetInstance(iqEl, JID.jidInstance((BareJID)userJID), JID.jidInstanceNS((BareJID)userJID, (String)resource));
        response.setPacketTo(connectionJID);
        writer.accept(response);
    }

    protected String generateId(BareJID channel, String packetID) throws XMPPProcessorException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(channel.toString().getBytes(StandardCharsets.UTF_8));
            byte[] hash = md.digest(packetID.getBytes(StandardCharsets.UTF_8));
            return Base64.encode((byte[])hash);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XMPPProcessorException(Authorization.INTERNAL_SERVER_ERROR);
        }
    }
}

