/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.kernel.beans.Bean;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.BareJID;

@Bean(name="http://jabber.org/protocol/jingle", parent=SessionManager.class, active=false)
public class Jingle
extends XMPPProcessor
implements XMPPProcessorIfc {
    protected static final String ID = "http://jabber.org/protocol/jingle";
    private static final Logger log = Logger.getLogger(Jingle.class.getName());
    private static final String[] JINGLE_PATH = new String[]{"iq", "jingle"};
    private static final String[][] ELEMENTS = new String[][]{JINGLE_PATH, JINGLE_PATH, JINGLE_PATH, {"iq", "session"}};
    private static final String[] XMLNSS = new String[]{"http://jabber.org/protocol/jingle", "http://www.xmpp.org/extensions/xep-0166.html#ns", "http://www.xmpp.org/extensions/xep-0167.html#ns", "http://www.google.com/session"};

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection conn, NonAuthUserRepository nonAuthUserRepo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (conn == null) {
            return;
        }
        try {
            BareJID id;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Received packet: " + packet);
            }
            if (conn.isUserId(id = packet.getStanzaTo().getBareJID())) {
                List<XMPPResourceConnection> res = conn.getParentSession().getActiveResources();
                XMPPResourceConnection session = conn;
                if (res != null && res.size() > 1) {
                    for (XMPPResourceConnection sess : res) {
                        if (sess.getSessionData("jingle") == null) continue;
                        session = sess;
                        break;
                    }
                }
                Packet result = packet.copyElementOnly();
                result.setPacketTo(session.getConnectionId());
                result.setPacketFrom(packet.getTo());
                results.offer(result);
            } else {
                results.offer(packet.copyElementOnly());
            }
        }
        catch (NotAuthorizedException e) {
            log.warning("NotAuthorizedException for packet: " + packet);
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }
}

