/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.kernel.beans.Bean;
import tigase.server.Iq;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.util.Base64;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.BareJID;

@Bean(name="jabber:iq:iq", parent=SessionManager.class, active=false)
public class JabberIqIq
extends XMPPProcessor
implements XMPPProcessorIfc,
XMPPPreprocessorIfc {
    private static final String[][] ELEMENTS = new String[][]{Iq.IQ_QUERY_PATH};
    private static final String LEVEL = "level";
    private static final String XMLNS = "jabber:iq:iq";
    protected static final String ID = "jabber:iq:iq";
    private static final String[] XMLNSS = new String[]{"jabber:iq:iq"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"jabber:iq:iq"})};
    private static Logger log = Logger.getLogger(JabberIqIq.class.getName());
    private static String[] not_so_smart_words = new String[]{"ZnVjaw==", "c2hpdA==", "d2hvcmU=", "ZGljaw==", "YXNz", "YW51cw==", "YXJzZQ==", "dmFnaW5h", "cG9ybg==", "cGVuaXM=", "cGlzcw==", "c3V4"};

    public static String calculateIQ(String iq_level) {
        double value = 100.0;
        try {
            value = Double.parseDouble(iq_level);
        }
        catch (NumberFormatException e) {
            value = 100.0;
        }
        if (value >= 140.0) {
            return "genius";
        }
        if (120.0 <= value && value <= 139.0) {
            return "very superior";
        }
        if (110.0 <= value && value <= 119.0) {
            return "superior";
        }
        if (90.0 <= value && value <= 109.0) {
            return "normal";
        }
        if (80.0 <= value && value <= 89.0) {
            return "dull";
        }
        if (70.0 <= value && value <= 79.0) {
            return "borderline deficiency";
        }
        if (50.0 <= value && value <= 69.0) {
            return "moron";
        }
        if (20.0 <= value && value <= 49.0) {
            return "imbecile";
        }
        if (0.0 <= value && value <= 19.0) {
            return "idiot";
        }
        return "out of range";
    }

    @Override
    public String id() {
        return "jabber:iq:iq";
    }

    @Override
    public boolean preProcess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        try {
            if (session != null && packet.getFrom() != null && packet.getFrom().equals((Object)session.getConnectionId()) && packet.getElemName() == "message") {
                this.evaluateMessage(session, packet.getElemCDataStaticStr(Message.MESSAGE_BODY_PATH));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null && packet.getType() != null && packet.getType() == StanzaType.get) {
            try {
                String iq_level = repo.getPublicData(packet.getStanzaTo().getBareJID(), "jabber:iq:iq", LEVEL, null);
                results.offer(this.getResponsePacket(packet, iq_level));
            }
            catch (UserNotFoundException iq_level) {
                // empty catch block
            }
            return;
        }
        if (session == null) {
            log.info("Session null, dropping packet: " + packet.toString());
            return;
        }
        try {
            BareJID id = null;
            if (packet.getStanzaTo() != null) {
                id = packet.getStanzaTo().getBareJID();
            }
            if (id == null || session.isUserId(id)) {
                StanzaType type = packet.getType();
                switch (type) {
                    case get: {
                        String iq_level = session.getPublicData("jabber:iq:iq", LEVEL, null);
                        results.offer(this.getResponsePacket(packet, iq_level));
                        break;
                    }
                    case set: {
                        if (packet.getFrom().equals((Object)session.getConnectionId())) {
                            String curr_iq = this.changeIq(session, -2.0);
                            results.offer(Authorization.NOT_ALLOWED.getResponseMessage(packet, "You are not allowed to set own IQ, your current IQ score: " + curr_iq, true));
                            break;
                        }
                        results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You are not authorized to set vcard data.", true));
                        break;
                    }
                    case result: {
                        Packet result = packet.copyElementOnly();
                        result.setPacketTo(session.getConnectionId());
                        result.setPacketFrom(packet.getTo());
                        results.offer(result);
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                        break;
                    }
                }
            } else {
                Packet result = packet.copyElementOnly();
                results.offer(result);
            }
        }
        catch (NotAuthorizedException e) {
            log.warning("Received privacy request but user session is not authorized yet: " + packet.toString());
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
        catch (TigaseDBException e) {
            log.warning("Database proble, please contact admin: " + e);
            results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database access problem, please contact administrator.", true));
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    private String changeIq(XMPPResourceConnection session, double val) throws NotAuthorizedException, TigaseDBException {
        double value = this.getIq(session);
        String curr = new Double(value += val).toString();
        session.setPublicData("jabber:iq:iq", LEVEL, curr);
        return curr;
    }

    private void evaluateMessage(XMPPResourceConnection session, String msg) throws NotAuthorizedException, TigaseDBException {
        if (msg == null) {
            return;
        }
        double val = 0.01;
        int msg_len = msg.trim().length();
        if (msg_len > 10 && msg_len < 100) {
            val += 0.01;
        }
        if (msg_len >= 100 && msg_len < 200) {
            val += 0.1;
        }
        if (msg_len >= 200 && msg_len < 500) {
            val += 0.01;
        }
        if (msg_len >= 500) {
            val -= 0.1;
        }
        for (String not_smart : not_so_smart_words) {
            if (!msg.contains(new String(Base64.decode((String)not_smart)))) continue;
            val -= 0.1;
        }
        double iq = this.getIq(session);
        val /= iq;
        String curr = new Double(iq += val).toString();
        session.setPublicData("jabber:iq:iq", LEVEL, curr);
    }

    private double getIq(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        String iq_level = session.getPublicData("jabber:iq:iq", LEVEL, "100");
        double iq = 100.0;
        try {
            iq = Double.parseDouble(iq_level);
        }
        catch (NumberFormatException e) {
            iq = 100.0;
        }
        return iq;
    }

    private Packet getResponsePacket(Packet packet, String iq_level) {
        if (iq_level == null) {
            iq_level = "100";
        }
        Element query = new Element("query", new Element[]{new Element("num", iq_level), new Element("desc", JabberIqIq.calculateIQ(iq_level))}, new String[]{"xmlns"}, new String[]{"jabber:iq:iq"});
        return packet.okResult(query, 0);
    }
}

