/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.xmpp.Authorization;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.impl.annotation.AnnotatedXMPPProcessor;
import tigase.xmpp.jid.JID;

public abstract class XMPPProcessorAbstract
extends AnnotatedXMPPProcessor
implements XMPPProcessorIfc {
    private static final Logger log = Logger.getLogger(XMPPProcessorAbstract.class.getName());

    public static boolean isFromUserSession(Packet packet, XMPPResourceConnection session) {
        boolean b;
        block2: {
            b = false;
            try {
                b = session != null && session.getConnectionId().equals((Object)packet.getPacketFrom());
            }
            catch (NoConnectionIdException e) {
                if (!log.isLoggable(Level.FINEST)) break block2;
                log.log(Level.FINEST, "There is no connectionId for given session: {0}, for packet={1}", new Object[]{session, packet});
            }
        }
        return b;
    }

    public static boolean isNullSession(Packet packet, XMPPResourceConnection session) {
        return session == null;
    }

    public static boolean isServerSession(Packet packet, XMPPResourceConnection session) {
        return session != null && session.isServerSession();
    }

    public static boolean isToUserSession(Packet packet, XMPPResourceConnection session) {
        boolean b;
        block2: {
            b = false;
            try {
                b = session != null && session.isUserId(packet.getStanzaTo().getBareJID());
            }
            catch (NotAuthorizedException e) {
                if (!log.isLoggable(Level.FINEST)) break block2;
                log.log(Level.FINEST, "Use session is not yet authorised: {0}, for packet={1}", new Object[]{session, packet});
            }
        }
        return b;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        try {
            if (session == null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Calling method: {0}, for packet={1}, for session={2}", new Object[]{"processNullSessionPacket", packet, session});
                }
                this.processNullSessionPacket(packet, repo, results, settings);
                return;
            }
            if (session.isServerSession()) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Calling method: {0}, for packet={1}, for session={2}", new Object[]{"processServerSessionPacket", packet, session});
                }
                this.processServerSessionPacket(packet, session, repo, results, settings);
                return;
            }
            try {
                JID connectionId = session.getConnectionId();
                if (connectionId.equals((Object)packet.getPacketFrom())) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Calling method: {0}, for packet={1}, for session={2}", new Object[]{"processFromUserPacket", packet, session});
                    }
                    this.processFromUserPacket(connectionId, packet, session, repo, results, settings);
                    return;
                }
            }
            catch (NoConnectionIdException ex) {
                log.log(Level.WARNING, "This should not happen, this is not a server session and still connection id is not set: " + session + ", packet: " + packet, ex);
            }
            try {
                if (session.isUserId(packet.getStanzaTo().getBareJID())) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Calling method: {0}, for packet={1}, for session={2}", new Object[]{"processToUserPacket", packet, session});
                    }
                    this.processToUserPacket(packet, session, repo, results, settings);
                }
            }
            catch (NotAuthorizedException ex) {
                log.log(Level.FINE, "Packet to a user session which is not yet authenticated: " + session + ", packet: " + packet);
            }
        }
        catch (PacketErrorTypeException ex) {
            log.info("Attempt to send an error response to the error packet: " + packet + ", session: " + session + ", plugin: " + this.id());
        }
    }

    public void processFromUserOutPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        results.offer(packet.copyElementOnly());
    }

    public void processFromUserPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        try {
            if (packet.getStanzaTo() == null || session.isLocalDomain(packet.getStanzaTo().toString(), false) || session.isUserId(packet.getStanzaTo().getBareJID())) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Calling method: {0}, for packet={1}, for session={2}", new Object[]{"processFromUserToServerPacket", packet, session});
                }
                this.processFromUserToServerPacket(connectionId, packet, session, repo, results, settings);
            } else {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Calling method: {0}, for packet={1}, for session={2}", new Object[]{"processFromUserOutPacket", packet, session});
                }
                this.processFromUserOutPacket(connectionId, packet, session, repo, results, settings);
            }
        }
        catch (NotAuthorizedException ex) {
            log.info("Session not yet authorized to send ping requests: " + session + ", packet: " + packet);
        }
    }

    public abstract void processFromUserToServerPacket(JID var1, Packet var2, XMPPResourceConnection var3, NonAuthUserRepository var4, Queue<Packet> var5, Map<String, Object> var6) throws PacketErrorTypeException;

    public void processNullSessionPacket(Packet packet, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
    }

    public abstract void processServerSessionPacket(Packet var1, XMPPResourceConnection var2, NonAuthUserRepository var3, Queue<Packet> var4, Map<String, Object> var5) throws PacketErrorTypeException;

    public void processToUserPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        try {
            ArrayList<XMPPResourceConnection> conns = new ArrayList<XMPPResourceConnection>(5);
            String resource = packet.getStanzaTo().getResource();
            if (resource == null && packet.getElemName() == "message") {
                conns.addAll(session.getActiveSessions());
            } else {
                XMPPResourceConnection con;
                XMPPSession parentSession = session.getParentSession();
                if (parentSession != null && (con = parentSession.getResourceForResource(resource)) != null) {
                    conns.add(con);
                }
            }
            if (conns.size() > 0) {
                for (XMPPResourceConnection con : conns) {
                    Packet result = packet.copyElementOnly();
                    result.setPacketTo(con.getConnectionId());
                    result.setPacketFrom(packet.getTo());
                    result.setStableId(packet.getStableId());
                    results.offer(result);
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.log(Level.FINEST, "Delivering packet: {0}, to session: {1}", new Object[]{packet, con});
                }
            } else {
                if (packet.getElemName() == "iq" && (packet.getType().equals((Object)StanzaType.error) || packet.getType().equals((Object)StanzaType.result))) {
                    return;
                }
                Packet result = Authorization.RECIPIENT_UNAVAILABLE.getResponseMessage(packet, "The recipient is no longer available.", true);
                result.setPacketFrom(null);
                result.setPacketTo(null);
                results.offer(result);
            }
        }
        catch (NotAuthorizedException e) {
            log.warning("NotAuthorizedException for packet: " + packet);
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
        catch (NoConnectionIdException ex) {
            log.log(Level.WARNING, "This should not happen, this is not a server session and still connection id is not set: " + session + ", packet: " + packet, ex);
        }
    }
}

