/*
 * Decompiled with CFR 0.152.
 */
package tigase.vhosts;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.vhosts.VHostItemExtension;
import tigase.vhosts.VHostItemExtensionProvider;
import tigase.vhosts.VHostManager;

@Bean(name="extension-manager", parent=VHostManager.class, active=true, exportable=true)
public class VHostItemExtensionManager {
    private static final Logger log = Logger.getLogger(VHostItemExtensionManager.class.getCanonicalName());
    @Inject(nullAllowed=true)
    private VHostItemExtensionProvider[] providers = new VHostItemExtensionProvider[0];
    private Map<Class<VHostItemExtension>, VHostItemExtensionProvider<?>> providersByClass = new ConcurrentHashMap();

    public void setProviders(VHostItemExtensionProvider[] providers) {
        this.providers = Optional.ofNullable(providers).orElseGet(() -> new VHostItemExtensionProvider[0]);
        HashSet<VHostItemExtensionProvider> newProviders = new HashSet<VHostItemExtensionProvider>(Arrays.asList(this.providers));
        this.providersByClass.values().removeIf(provider -> !newProviders.contains(provider));
        Arrays.stream(this.providers).forEach(provider -> this.providersByClass.put(provider.getExtensionClazz(), (VHostItemExtensionProvider<?>)provider));
    }

    public <T extends VHostItemExtension> T newExtensionInstanceForClass(Class<T> extensionClass) {
        return (T)((VHostItemExtension)Optional.ofNullable(this.providersByClass.get(extensionClass)).map(this::newExtensionInstance).orElse(null));
    }

    public <T extends VHostItemExtension> Stream<T> newExtensionInstances() {
        return this.newExtensionInstances(Arrays.stream(this.providers));
    }

    public <T extends VHostItemExtension> Stream<T> newExtensionInstances(Stream<VHostItemExtensionProvider> providerStream) {
        return providerStream.map(this::newExtensionInstance).filter(Objects::nonNull);
    }

    protected <T extends VHostItemExtension> T newExtensionInstance(VHostItemExtensionProvider<T> provider) {
        Class<T> extensionClass = provider.getExtensionClazz();
        try {
            return (T)((VHostItemExtension)extensionClass.newInstance());
        }
        catch (Throwable ex) {
            log.log(Level.WARNING, "Could not create extension " + extensionClass + " returned by " + provider.getClass().getCanonicalName(), ex);
            return null;
        }
    }

    public Stream<VHostItemExtension> addMissingExtensions(Collection<VHostItemExtension> extensions) {
        Set existingExtensions = extensions.stream().map(ext -> ext.getId()).collect(Collectors.toSet());
        return Stream.concat(extensions.stream(), this.newExtensionInstances(Arrays.stream(this.providers).filter(provider -> !existingExtensions.contains(provider.getId()))));
    }
}

