/*
 * Decompiled with CFR 0.152.
 */
package tigase.vhosts;

import java.util.Set;
import tigase.annotations.TigaseDeprecated;
import tigase.db.comp.RepositoryItem;
import tigase.vhosts.VHostItemExtension;
import tigase.vhosts.filter.DomainFilterPolicy;
import tigase.xmpp.jid.JID;

public interface VHostItem
extends RepositoryItem,
Comparable<VHostItem> {
    public static final String DEF_VHOST_KEY = "default";

    @Override
    default public int compareTo(VHostItem o) {
        return this.getKey().compareTo(o.getKey());
    }

    public String[] getComps();

    public int[] getC2SPortsAllowed();

    @Deprecated
    @TigaseDeprecated(since="8.1.0", removeIn="9.0.0")
    public <T> T getData(String var1);

    public DomainFilterPolicy getDomainFilter();

    public String[] getDomainFilterDomains();

    public <T extends VHostItemExtension> T getExtension(Class<T> var1);

    public <T extends VHostItemExtension> Set<T> getExtensions();

    public Set<Class<? extends VHostItemExtension>> getExtensionClasses();

    public Long getMaxUsersNumber();

    public JID getMessageForward();

    default public JID getMessageForwardAddress() {
        return this.getMessageForward();
    }

    public String getOtherDomainParams();

    public JID getPresenceForward();

    default public JID getPresenceForwardAddress() {
        return this.getPresenceForward();
    }

    public String getS2sSecret();

    public Set<String> getTrustedJIDs();

    public JID getVhost();

    public void setKey(String var1);

    @Override
    default public boolean isAdmin(String id) {
        if (this.getAdmins() == null) {
            return false;
        }
        for (String admin : this.getAdmins()) {
            if (!admin.equals(id)) continue;
            return true;
        }
        return false;
    }

    public boolean isAnonymousEnabled();

    @Deprecated
    @TigaseDeprecated(since="8.1.0", removeIn="9.0.0")
    public boolean isData(String var1);

    public boolean isEnabled();

    public boolean isRegisterEnabled();

    public boolean isTlsRequired();

    default public boolean isTrustedJID(JID jid) {
        Set<String> trustedJids = this.getTrustedJIDs();
        if (trustedJids == null) {
            return false;
        }
        return trustedJids.contains(jid.toString()) || trustedJids.contains(jid.getBareJID().toString()) || trustedJids.contains(jid.getDomain());
    }

    public String[] getSaslAllowedMechanisms();
}

