/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.routing;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.xmppclient.ClientConnectionManager;
import tigase.util.dns.DNSResolverFactory;

public class RoutingsContainer {
    private static final Logger log = Logger.getLogger("tigase.util.RoutingsContainer");
    private RoutingComputer comp = null;

    public RoutingsContainer(boolean multiMode) {
        this.comp = multiMode ? new MultiMode() : new SingleMode();
    }

    public void addRouting(String pattern, String address) {
        this.comp.addRouting(pattern, address);
    }

    public String computeRouting(String pattern) {
        return this.comp.computeRouting(pattern);
    }

    @Bean(name="routingComputer", parent=ClientConnectionManager.class, active=true)
    public static class SingleMode
    extends AbstractRoutingComputer {
        private String routing;

        @Override
        public void addRouting(String pattern, String address) {
            this.routing = address;
        }

        @Override
        public String computeRouting(String address) {
            return this.routing;
        }
    }

    public static class MultiMode
    extends AbstractRoutingComputer {
        private String def = null;
        @ConfigField(desc="Routing patterns")
        private Map<Pattern, String> routings = new LinkedHashMap<Pattern, String>();

        @Override
        public void addRouting(String pattern, String address) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Adding routing: " + pattern + " --> " + address);
            }
            this.routings.put(Pattern.compile(pattern), address);
            if (this.def == null) {
                this.def = address;
            }
        }

        @Override
        public String computeRouting(String address) {
            if (address == null) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("For null address returning default routing: " + this.def);
                }
                return this.def;
            }
            for (Map.Entry<Pattern, String> entry : this.routings.entrySet()) {
                if (!entry.getKey().matcher(address).find()) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("For address: " + address + " pattern: " + entry.getKey().pattern() + " matched.");
                }
                return entry.getValue();
            }
            return this.def;
        }
    }

    public static abstract class AbstractRoutingComputer
    implements RoutingComputer {
        public AbstractRoutingComputer() {
            this.addRouting(".+", "sess-man@" + DNSResolverFactory.getInstance().getDefaultHost());
        }
    }

    public static interface RoutingComputer {
        public void addRouting(String var1, String var2);

        public String computeRouting(String var1);
    }
}

