/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.QueueType;
import tigase.stats.StatRecord;
import tigase.stats.StatisticType;
import tigase.util.repository.DataTypes;

public class StatisticsList
implements Iterable<StatRecord> {
    private static final Logger log = Logger.getLogger(StatisticsList.class.getName());
    private final LinkedHashMap<String, LinkedHashMap<String, StatRecord>> stats = new LinkedHashMap();
    private Level statLevel = Level.ALL;

    public StatisticsList(Level level) {
        this.statLevel = level;
    }

    public boolean add(String comp, String description, long value, Level recordLevel) {
        return this.addEntry(comp, description, recordLevel, new StatRecord(comp, description, value, recordLevel));
    }

    public boolean add(String comp, String description, int value, Level recordLevel) {
        return this.addEntry(comp, description, recordLevel, new StatRecord(comp, description, value, recordLevel));
    }

    public boolean add(String comp, String description, String value, Level recordLevel) {
        return this.addEntry(comp, description, recordLevel, new StatRecord(comp, description, value, recordLevel));
    }

    public boolean add(String comp, String description, float value, Level recordLevel) {
        return this.addEntry(comp, description, recordLevel, new StatRecord(comp, description, value, recordLevel));
    }

    public <E extends Number> boolean add(String comp, String description, Collection<E> value, Level recordLevel) {
        return this.addEntry(comp, description, recordLevel, new StatRecord<E>(comp, description, value, recordLevel));
    }

    public LinkedHashMap<String, StatRecord> addCompStats(String comp) {
        LinkedHashMap<String, StatRecord> compStats = new LinkedHashMap<String, StatRecord>();
        this.stats.put(comp, compStats);
        return compStats;
    }

    public boolean checkLevel(Level recordLevel) {
        return recordLevel.intValue() >= this.statLevel.intValue();
    }

    public boolean checkLevel(Level recordLevel, long value) {
        return this.checkLevel(recordLevel) && (value != 0L || this.checkLevel(Level.FINEST));
    }

    public boolean checkLevel(Level recordLevel, StatRecord record) {
        return this.checkLevel(recordLevel) && (record.isNonZero() || this.checkLevel(Level.FINEST));
    }

    public boolean checkLevel(Level recordLevel, int value) {
        return this.checkLevel(recordLevel) && (value != 0 || this.checkLevel(Level.FINEST));
    }

    public int getCompConnections(String comp) {
        return this.getValue(comp, "Open connections", 0);
    }

    public long getCompIq(String comp) {
        return this.getCompIqSent(comp) + this.getCompIqReceived(comp);
    }

    public long getCompIqReceived(String comp) {
        return this.getValue(comp, QueueType.IN_QUEUE.name() + " processed IQ", 0L);
    }

    public long getCompIqSent(String comp) {
        return this.getValue(comp, QueueType.OUT_QUEUE.name() + " processed IQ", 0L);
    }

    public Set<String> getCompNames() {
        return this.stats.keySet();
    }

    public long getCompMsg(String comp) {
        return this.getCompMsgSent(comp) + this.getCompMsgReceived(comp);
    }

    public long getCompMsgReceived(String comp) {
        return this.getValue(comp, QueueType.IN_QUEUE.name() + " processed messages", 0L);
    }

    public long getCompMsgSent(String comp) {
        return this.getValue(comp, QueueType.OUT_QUEUE.name() + " processed messages", 0L);
    }

    public long getCompPackets(String comp) {
        return this.getCompSentPackets(comp) + this.getCompReceivedPackets(comp);
    }

    public long getCompPres(String comp) {
        return this.getCompPresSent(comp) + this.getCompPresReceived(comp);
    }

    public long getCompPresReceived(String comp) {
        return this.getValue(comp, QueueType.IN_QUEUE.name() + " processed presences", 0L);
    }

    public long getCompPresSent(String comp) {
        return this.getValue(comp, QueueType.OUT_QUEUE.name() + " processed presences", 0L);
    }

    public long getCompReceivedPackets(String comp) {
        return this.getValue(comp, StatisticType.MSG_RECEIVED_OK.getDescription(), 0L);
    }

    public long getCompSentPackets(String comp) {
        return this.getValue(comp, StatisticType.MSG_SENT_OK.getDescription(), 0L);
    }

    public LinkedHashMap<String, StatRecord> getCompStats(String comp) {
        return this.stats.get(comp);
    }

    public long getValue(String comp, String description, long def) {
        StatRecord rec;
        long result = def;
        LinkedHashMap<String, StatRecord> compStats = this.stats.get(comp);
        if (compStats != null && (rec = compStats.get(description)) != null) {
            result = rec.getLongValue();
        }
        return result;
    }

    public float getValue(String comp, String description, float def) {
        StatRecord rec;
        float result = def;
        LinkedHashMap<String, StatRecord> compStats = this.stats.get(comp);
        if (compStats != null && (rec = compStats.get(description)) != null) {
            result = rec.getFloatValue();
        }
        return result;
    }

    public int getValue(String comp, String description, int def) {
        StatRecord rec;
        int result = def;
        LinkedHashMap<String, StatRecord> compStats = this.stats.get(comp);
        if (compStats != null && (rec = compStats.get(description)) != null) {
            result = rec.getIntValue();
        }
        return result;
    }

    public String getValue(String comp, String description, String def) {
        StatRecord rec;
        String result = def;
        LinkedHashMap<String, StatRecord> compStats = this.stats.get(comp);
        if (compStats != null && (rec = compStats.get(description)) != null) {
            result = rec.getValue();
        }
        return result;
    }

    public <E> Collection<E> getValue(String comp, String description, Collection<E> def) {
        StatRecord rec;
        Collection<E> result = def;
        LinkedHashMap<String, StatRecord> compStats = this.stats.get(comp);
        if (compStats != null && (rec = compStats.get(description)) != null) {
            result = rec.getCollection();
        }
        return result;
    }

    public <E> Collection<E> getCollectionValue(String dataId) {
        String dataName = DataTypes.stripNameFromTypeId(dataId);
        int idx = dataName.indexOf(47);
        String comp = dataName.substring(0, idx);
        String descr = dataName.substring(idx + 1);
        return this.getCollectionValue(comp, descr, null);
    }

    public <E> Collection<E> getCollectionValue(String comp, String description, Collection<E> def) {
        StatRecord rec;
        Collection<E> result = def;
        LinkedHashMap<String, StatRecord> compStats = this.stats.get(comp);
        if (compStats != null && (rec = compStats.get(description)) != null) {
            result = rec.getCollection();
        }
        return result;
    }

    public Object getValue(String dataId) {
        char dataType = DataTypes.decodeTypeIdFromName(dataId);
        String dataName = DataTypes.stripNameFromTypeId(dataId);
        int idx = dataName.indexOf(47);
        String comp = dataName.substring(0, idx);
        String descr = dataName.substring(idx + 1);
        switch (dataType) {
            case 'L': {
                return this.getValue(comp, descr, 0L);
            }
            case 'I': {
                return this.getValue(comp, descr, 0);
            }
            case 'F': {
                return Float.valueOf(this.getValue(comp, descr, 0.0f));
            }
            case 'C': {
                return this.getCollectionValue(comp, descr, null);
            }
        }
        return this.getValue(comp, descr, " ");
    }

    @Override
    public Iterator<StatRecord> iterator() {
        return new StatsIterator();
    }

    public String toString() {
        return this.stats.toString();
    }

    private boolean addEntry(String comp, String description, Level recordLevel, StatRecord statRecord) {
        description = description.intern();
        if (this.checkLevel(recordLevel, statRecord)) {
            LinkedHashMap<String, StatRecord> compStats = this.stats.get(comp);
            if (compStats == null) {
                compStats = this.addCompStats(comp);
            }
            compStats.put(description, statRecord);
            return true;
        }
        return false;
    }

    private class StatsIterator
    implements Iterator<StatRecord> {
        Iterator<LinkedHashMap<String, StatRecord>> compsIt;
        Iterator<StatRecord> recIt;

        private StatsIterator() {
            this.compsIt = StatisticsList.this.stats.values().iterator();
            this.recIt = null;
        }

        @Override
        public boolean hasNext() {
            if (this.recIt == null || !this.recIt.hasNext()) {
                if (this.compsIt.hasNext()) {
                    this.recIt = this.compsIt.next().values().iterator();
                } else {
                    return false;
                }
            }
            return this.recIt.hasNext();
        }

        @Override
        public StatRecord next() throws NoSuchElementException {
            if (this.recIt == null || !this.recIt.hasNext()) {
                if (this.compsIt.hasNext()) {
                    this.recIt = this.compsIt.next().values().iterator();
                } else {
                    throw new NoSuchElementException("No more statistics.");
                }
            }
            return this.recIt.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

