/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver.proc;

import java.io.IOException;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.kernel.beans.Bean;
import tigase.server.Packet;
import tigase.server.xmppserver.CID;
import tigase.server.xmppserver.S2SConnectionManager;
import tigase.server.xmppserver.S2SIOService;
import tigase.server.xmppserver.proc.S2SAbstractProcessor;
import tigase.xml.Element;

@Bean(name="startTLS", parent=S2SConnectionManager.class, active=true)
public class StartTLS
extends S2SAbstractProcessor {
    private static final Logger log = Logger.getLogger(StartTLS.class.getName());
    private static final Element features = new Element("starttls", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-tls"});
    private static final Element features_required = new Element("starttls", new Element[]{new Element("required")}, new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-tls"});
    private static final Element starttls_el = new Element("starttls", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-tls"});
    private static final Element proceed_el = new Element("proceed", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-tls"});

    @Override
    public int order() {
        return S2SAbstractProcessor.Order.StartTLS.ordinal();
    }

    @Override
    public boolean process(Packet p, S2SIOService serv, Queue<Packet> results) {
        if (p.isElement("starttls", "urn:ietf:params:xml:ns:xmpp-tls")) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Sending packet: {1} [{0}]", new Object[]{serv, proceed_el});
            }
            this.handler.writeRawData(serv, proceed_el.toString());
            try {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Starting TLS handshaking server side. [{0}]", serv);
                }
                serv.getSessionData().put("TLS", "TLS");
                serv.startTLS(false, this.handler.isTlsWantClientAuthEnabled(), this.handler.isTlsNeedClientAuthEnabled());
            }
            catch (IOException ex) {
                log.log(Level.INFO, "Problem with TLS initialization.", ex);
            }
            return true;
        }
        if (p.isElement("proceed", "urn:ietf:params:xml:ns:xmpp-tls")) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Received TLS proceed. [{0}]", serv);
            }
            try {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Starting TLS handshaking client side. [{0}]", serv);
                }
                serv.getSessionData().put("TLS", "TLS");
                serv.startTLS(true, this.handler.isTlsWantClientAuthEnabled(), this.handler.isTlsNeedClientAuthEnabled());
            }
            catch (IOException ex) {
                log.log(Level.INFO, "Problem with TLS initialization.", ex);
            }
            return true;
        }
        if (p.isElement("features", "http://etherx.jabber.org/streams") && p.getElement().getChildren() != null && !p.getElement().getChildren().isEmpty()) {
            CID cid;
            boolean skipTLS;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Stream features received: {1} [{0}]", new Object[]{serv, p});
            }
            boolean bl = skipTLS = (cid = (CID)serv.getSessionData().get("cid")) != null && this.skipTLSForHost(cid.getRemoteHost());
            if (p.isXMLNSStaticStr(FEATURES_STARTTLS_PATH, "urn:ietf:params:xml:ns:xmpp-tls") && !skipTLS) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Sending packet: {1} [{0}]", new Object[]{serv, starttls_el});
                }
                this.handler.writeRawData(serv, starttls_el.toString());
                return true;
            }
        }
        return false;
    }

    @Override
    public void streamFeatures(S2SIOService serv, List<Element> results) {
        if (!serv.getSessionData().containsKey("TLS")) {
            CID cid = (CID)serv.getSessionData().get("cid");
            if (cid != null && !this.skipTLSForHost(cid.getRemoteHost()) && this.handler.isTlsRequired(cid.getLocalHost())) {
                results.add(features_required);
            } else {
                results.add(features);
            }
        }
    }
}

