/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.util.LinkedHashSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class IPMonitor
extends Thread {
    private static final Logger log = Logger.getLogger(IPMonitor.class.getName());
    private static final int MAX_SIZE = 50;
    private static final long CLEANUP_RATE = 10000L;
    private static final long DISC_THRESHOLD = 200L;
    private long[] ip_cnts = new long[50];
    private LinkedHashSet<String> ips = new LinkedHashSet();
    private LinkedBlockingQueue<String> queue = new LinkedBlockingQueue();
    private boolean stopped = false;
    private Timer timer = new Timer("IPMonitor Timer", true);

    public IPMonitor() {
        this.setName(IPMonitor.class.getSimpleName());
        this.setDaemon(true);
        for (int i = 0; i < this.ip_cnts.length; ++i) {
            this.ip_cnts[i] = 0L;
        }
    }

    public void addDisconnect(String ip) {
        this.queue.offer(ip);
    }

    @Override
    public void run() {
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                for (String ip : IPMonitor.this.ips) {
                    int idx = Math.abs(ip.hashCode() % IPMonitor.this.ip_cnts.length);
                    if (IPMonitor.this.ip_cnts[idx] > 200L) {
                        log.warning("Many disconnects for IP: " + ip + " - " + IPMonitor.this.ip_cnts[idx]);
                    }
                    IPMonitor.this.ip_cnts[idx] = 0L;
                }
            }
        }, 10000L, 10000L);
        while (!this.stopped) {
            try {
                int idx;
                String ip = this.queue.poll(10L, TimeUnit.SECONDS);
                if (ip == null) continue;
                int n = idx = Math.abs(ip.hashCode()) % this.ip_cnts.length;
                this.ip_cnts[n] = this.ip_cnts[n] + 1L;
                if (this.ips.size() >= 50) continue;
                this.ips.add(ip);
            }
            catch (Exception e) {
                log.warning("Error processing queue: " + e);
            }
        }
        this.timer.cancel();
    }

    public void stopThread() {
        this.stopped = true;
        this.timer.cancel();
    }
}

